/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.neural_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.neural_network.NeuralInputs;
import org.dmg.pmml.neural_network.NeuralLayer;
import org.dmg.pmml.neural_network.NeuralOutputs;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "neuralInputs", "neuralLayers", "neuralOutputs", "modelVerification"})
@XmlRootElement(name="NeuralNetwork", namespace="http://www.dmg.org/PMML-4_3")
public class NeuralNetwork
extends Model
implements HasExtensions<NeuralNetwork> {
    @XmlAttribute(name="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    private MiningFunction miningFunction;
    @XmlAttribute(name="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="activationFunction", required=true)
    private ActivationFunction activationFunction;
    @XmlAttribute(name="normalizationMethod")
    private NormalizationMethod normalizationMethod;
    @XmlAttribute(name="threshold")
    private Double threshold;
    @XmlAttribute(name="width")
    private Double width;
    @XmlAttribute(name="altitude")
    private Double altitude;
    @XmlAttribute(name="numberOfLayers")
    private Integer numberOfLayers;
    @XmlAttribute(name="isScorable")
    @Added(value=Version.PMML_4_1)
    private Boolean scorable;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_3", required=true)
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_3")
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_3")
    private ModelStats modelStats;
    @XmlElement(name="ModelExplanation", namespace="http://www.dmg.org/PMML-4_3")
    @Added(value=Version.PMML_4_0)
    private ModelExplanation modelExplanation;
    @XmlElement(name="Targets", namespace="http://www.dmg.org/PMML-4_3")
    private Targets targets;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_3")
    private LocalTransformations localTransformations;
    @XmlElement(name="NeuralInputs", namespace="http://www.dmg.org/PMML-4_3", required=true)
    private NeuralInputs neuralInputs;
    @XmlElement(name="NeuralLayer", namespace="http://www.dmg.org/PMML-4_3", required=true)
    private List<NeuralLayer> neuralLayers;
    @XmlElement(name="NeuralOutputs", namespace="http://www.dmg.org/PMML-4_3")
    private NeuralOutputs neuralOutputs;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_3")
    private ModelVerification modelVerification;
    private static final Double DEFAULT_THRESHOLD = 0.0;
    private static final Double DEFAULT_ALTITUDE = 1.0;
    private static final Boolean DEFAULT_SCORABLE = true;

    public NeuralNetwork() {
    }

    public NeuralNetwork(MiningFunction miningFunction, ActivationFunction activationFunction, MiningSchema miningSchema, NeuralInputs neuralInputs, List<NeuralLayer> neuralLayers) {
        this.miningFunction = miningFunction;
        this.activationFunction = activationFunction;
        this.miningSchema = miningSchema;
        this.neuralInputs = neuralInputs;
        this.neuralLayers = neuralLayers;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public NeuralNetwork setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return this.miningFunction;
    }

    @Override
    public NeuralNetwork setMiningFunction(MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public NeuralNetwork setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public ActivationFunction getActivationFunction() {
        return this.activationFunction;
    }

    public NeuralNetwork setActivationFunction(ActivationFunction activationFunction) {
        this.activationFunction = activationFunction;
        return this;
    }

    public NormalizationMethod getNormalizationMethod() {
        if (this.normalizationMethod == null) {
            return NormalizationMethod.NONE;
        }
        return this.normalizationMethod;
    }

    public NeuralNetwork setNormalizationMethod(NormalizationMethod normalizationMethod) {
        this.normalizationMethod = normalizationMethod;
        return this;
    }

    public Double getThreshold() {
        if (this.threshold == null) {
            return DEFAULT_THRESHOLD;
        }
        return this.threshold;
    }

    public NeuralNetwork setThreshold(Double threshold) {
        this.threshold = threshold;
        return this;
    }

    public Double getWidth() {
        return this.width;
    }

    public NeuralNetwork setWidth(Double width) {
        this.width = width;
        return this;
    }

    public Double getAltitude() {
        if (this.altitude == null) {
            return DEFAULT_ALTITUDE;
        }
        return this.altitude;
    }

    public NeuralNetwork setAltitude(Double altitude) {
        this.altitude = altitude;
        return this;
    }

    public Integer getNumberOfLayers() {
        return this.numberOfLayers;
    }

    public NeuralNetwork setNumberOfLayers(Integer numberOfLayers) {
        this.numberOfLayers = numberOfLayers;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return DEFAULT_SCORABLE;
        }
        return this.scorable;
    }

    @Override
    public NeuralNetwork setScorable(Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public NeuralNetwork setMiningSchema(MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public NeuralNetwork setOutput(Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public NeuralNetwork setModelStats(ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return this.modelExplanation;
    }

    @Override
    public NeuralNetwork setModelExplanation(ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public Targets getTargets() {
        return this.targets;
    }

    @Override
    public NeuralNetwork setTargets(Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public NeuralNetwork setLocalTransformations(LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public NeuralInputs getNeuralInputs() {
        return this.neuralInputs;
    }

    public NeuralNetwork setNeuralInputs(NeuralInputs neuralInputs) {
        this.neuralInputs = neuralInputs;
        return this;
    }

    public List<NeuralLayer> getNeuralLayers() {
        if (this.neuralLayers == null) {
            this.neuralLayers = new ArrayList<NeuralLayer>();
        }
        return this.neuralLayers;
    }

    public NeuralOutputs getNeuralOutputs() {
        return this.neuralOutputs;
    }

    public NeuralNetwork setNeuralOutputs(NeuralOutputs neuralOutputs) {
        this.neuralOutputs = neuralOutputs;
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public NeuralNetwork setModelVerification(ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public NeuralNetwork addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasNeuralLayers() {
        return this.neuralLayers != null && this.neuralLayers.size() > 0;
    }

    public NeuralNetwork addNeuralLayers(NeuralLayer ... neuralLayers) {
        this.getNeuralLayers().addAll(Arrays.asList(neuralLayers));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getMiningSchema(), this.getOutput(), this.getModelStats(), this.getModelExplanation(), this.getTargets(), this.getLocalTransformations(), this.getNeuralInputs());
            }
            if (status == VisitorAction.CONTINUE && this.hasNeuralLayers()) {
                status = PMMLObject.traverse(visitor, this.getNeuralLayers());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getNeuralOutputs(), (Visitable)this.getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum NormalizationMethod {
        NONE("none"),
        SIMPLEMAX("simplemax"),
        SOFTMAX("softmax");

        private final String value;

        private NormalizationMethod(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static NormalizationMethod fromValue(String v) {
            for (NormalizationMethod c : NormalizationMethod.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum ActivationFunction {
        THRESHOLD("threshold"),
        LOGISTIC("logistic"),
        TANH("tanh"),
        IDENTITY("identity"),
        EXPONENTIAL("exponential"),
        RECIPROCAL("reciprocal"),
        SQUARE("square"),
        GAUSS("Gauss"),
        SINE("sine"),
        COSINE("cosine"),
        ELLIOTT("Elliott"),
        ARCTAN("arctan"),
        RECTIFIER("rectifier"),
        RADIAL_BASIS("radialBasis");

        private final String value;

        private ActivationFunction(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static ActivationFunction fromValue(String v) {
            for (ActivationFunction c : ActivationFunction.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

