
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;sequence maxOccurs="unbounded" minOccurs="2">
 *           &lt;group ref="{http://www.dmg.org/PMML-4_3}PREDICATE"/>
 *         &lt;/sequence>
 *       &lt;/sequence>
 *       &lt;attribute name="booleanOperator" use="required">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="or"/>
 *             &lt;enumeration value="and"/>
 *             &lt;enumeration value="xor"/>
 *             &lt;enumeration value="surrogate"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "predicates"
})
@XmlRootElement(name = "CompoundPredicate", namespace = "http://www.dmg.org/PMML-4_3")
public class CompoundPredicate
    extends org.dmg.pmml.Predicate
    implements HasExtensions<CompoundPredicate>
{

    @XmlAttribute(name = "booleanOperator", required = true)
    private CompoundPredicate.BooleanOperator booleanOperator;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "SimplePredicate", namespace = "http://www.dmg.org/PMML-4_3", type = SimplePredicate.class),
        @XmlElement(name = "CompoundPredicate", namespace = "http://www.dmg.org/PMML-4_3", type = CompoundPredicate.class),
        @XmlElement(name = "SimpleSetPredicate", namespace = "http://www.dmg.org/PMML-4_3", type = SimpleSetPredicate.class),
        @XmlElement(name = "True", namespace = "http://www.dmg.org/PMML-4_3", type = True.class),
        @XmlElement(name = "False", namespace = "http://www.dmg.org/PMML-4_3", type = False.class)
    })
    private List<org.dmg.pmml.Predicate> predicates;
    private final static long serialVersionUID = 67305473L;

    public CompoundPredicate() {
    }

    public CompoundPredicate(
        @org.jpmml.model.Property("booleanOperator")
        CompoundPredicate.BooleanOperator booleanOperator) {
        this.booleanOperator = booleanOperator;
    }

    /**
     * Gets the value of the booleanOperator property.
     * 
     * @return
     *     possible object is
     *     {@link CompoundPredicate.BooleanOperator }
     *     
     */
    public CompoundPredicate.BooleanOperator getBooleanOperator() {
        return booleanOperator;
    }

    /**
     * Sets the value of the booleanOperator property.
     * 
     * @param booleanOperator
     *     allowed object is
     *     {@link CompoundPredicate.BooleanOperator }
     *     
     */
    public CompoundPredicate setBooleanOperator(
        @org.jpmml.model.Property("booleanOperator")
        CompoundPredicate.BooleanOperator booleanOperator) {
        this.booleanOperator = booleanOperator;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the predicates property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the predicates property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPredicates().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SimplePredicate }
     * {@link CompoundPredicate }
     * {@link SimpleSetPredicate }
     * {@link True }
     * {@link False }
     * 
     * 
     */
    public List<org.dmg.pmml.Predicate> getPredicates() {
        if (predicates == null) {
            predicates = new ArrayList<org.dmg.pmml.Predicate>();
        }
        return this.predicates;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public CompoundPredicate addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasPredicates() {
        return ((this.predicates!= null)&&(this.predicates.size()> 0));
    }

    public CompoundPredicate addPredicates(org.dmg.pmml.Predicate... predicates) {
        getPredicates().addAll(Arrays.asList(predicates));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasPredicates()) {
                status = PMMLObject.traverse(visitor, getPredicates());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="or"/>
     *     &lt;enumeration value="and"/>
     *     &lt;enumeration value="xor"/>
     *     &lt;enumeration value="surrogate"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum BooleanOperator {

        @XmlEnumValue("or")
        OR("or"),
        @XmlEnumValue("and")
        AND("and"),
        @XmlEnumValue("xor")
        XOR("xor"),
        @XmlEnumValue("surrogate")
        SURROGATE("surrogate");
        private final String value;

        BooleanOperator(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static CompoundPredicate.BooleanOperator fromValue(String v) {
            for (CompoundPredicate.BooleanOperator c: CompoundPredicate.BooleanOperator.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
