
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Deprecated;
import org.jpmml.schema.Optional;
import org.jpmml.schema.Required;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;sequence minOccurs="0">
 *           &lt;element ref="{http://www.dmg.org/PMML-4_3}Decisions" minOccurs="0"/>
 *           &lt;group ref="{http://www.dmg.org/PMML-4_3}EXPRESSION"/>
 *         &lt;/sequence>
 *       &lt;/sequence>
 *       &lt;attribute name="name" use="required" type="{http://www.dmg.org/PMML-4_3}FIELD-NAME" />
 *       &lt;attribute name="displayName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="optype" type="{http://www.dmg.org/PMML-4_3}OPTYPE" />
 *       &lt;attribute name="dataType" use="required" type="{http://www.dmg.org/PMML-4_3}DATATYPE" />
 *       &lt;attribute name="targetField" type="{http://www.dmg.org/PMML-4_3}FIELD-NAME" />
 *       &lt;attribute name="feature" type="{http://www.dmg.org/PMML-4_3}RESULT-FEATURE" default="predictedValue" />
 *       &lt;attribute name="value" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="ruleFeature" default="consequent">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="antecedent"/>
 *             &lt;enumeration value="consequent"/>
 *             &lt;enumeration value="rule"/>
 *             &lt;enumeration value="ruleId"/>
 *             &lt;enumeration value="confidence"/>
 *             &lt;enumeration value="support"/>
 *             &lt;enumeration value="lift"/>
 *             &lt;enumeration value="leverage"/>
 *             &lt;enumeration value="affinity"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="algorithm" default="exclusiveRecommendation">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="recommendation"/>
 *             &lt;enumeration value="exclusiveRecommendation"/>
 *             &lt;enumeration value="ruleAssociation"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="rank" type="{http://www.dmg.org/PMML-4_3}INT-NUMBER" default="1" />
 *       &lt;attribute name="rankBasis" default="confidence">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="confidence"/>
 *             &lt;enumeration value="support"/>
 *             &lt;enumeration value="lift"/>
 *             &lt;enumeration value="leverage"/>
 *             &lt;enumeration value="affinity"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="rankOrder" default="descending">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="descending"/>
 *             &lt;enumeration value="ascending"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="isMultiValued" type="{http://www.w3.org/2001/XMLSchema}anySimpleType" default="0" />
 *       &lt;attribute name="segmentId" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="isFinalResult" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "decisions",
    "expression"
})
@XmlRootElement(name = "OutputField", namespace = "http://www.dmg.org/PMML-4_3")
public class OutputField
    extends Field
    implements HasExpression<OutputField> , HasExtensions<OutputField>
{

    @XmlAttribute(name = "name", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName name;
    @XmlAttribute(name = "displayName")
    private String displayName;
    @XmlAttribute(name = "optype")
    private OpType opType;
    @XmlAttribute(name = "dataType", required = true)
    @Required(Version.PMML_4_3)
    private DataType dataType;
    @XmlAttribute(name = "targetField")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @Optional(Version.PMML_3_1)
    private FieldName targetField;
    @XmlAttribute(name = "feature")
    private ResultFeature resultFeature;
    @XmlAttribute(name = "value")
    private String value;
    @XmlAttribute(name = "ruleFeature")
    @Added(Version.PMML_4_0)
    @Deprecated(Version.PMML_4_2)
    private OutputField.RuleFeature ruleFeature;
    @XmlAttribute(name = "algorithm")
    @Added(Version.PMML_4_0)
    private OutputField.Algorithm algorithm;
    @XmlAttribute(name = "rank")
    private Integer rank;
    @XmlAttribute(name = "rankBasis")
    @Added(Version.PMML_4_0)
    private OutputField.RankBasis rankBasis;
    @XmlAttribute(name = "rankOrder")
    @Added(Version.PMML_4_0)
    private OutputField.RankOrder rankOrder;
    @XmlAttribute(name = "isMultiValued")
    @XmlSchemaType(name = "anySimpleType")
    @Added(Version.PMML_4_0)
    @Deprecated(Version.PMML_4_2)
    private String isMultiValued;
    @XmlAttribute(name = "segmentId")
    @Added(Version.PMML_4_1)
    private String segmentId;
    @XmlAttribute(name = "isFinalResult")
    @Added(Version.PMML_4_3)
    private Boolean finalResult;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "Decisions", namespace = "http://www.dmg.org/PMML-4_3")
    @Added(Version.PMML_4_1)
    private Decisions decisions;
    @XmlElements({
        @XmlElement(name = "Constant", namespace = "http://www.dmg.org/PMML-4_3", type = Constant.class),
        @XmlElement(name = "FieldRef", namespace = "http://www.dmg.org/PMML-4_3", type = FieldRef.class),
        @XmlElement(name = "NormContinuous", namespace = "http://www.dmg.org/PMML-4_3", type = NormContinuous.class),
        @XmlElement(name = "NormDiscrete", namespace = "http://www.dmg.org/PMML-4_3", type = NormDiscrete.class),
        @XmlElement(name = "Discretize", namespace = "http://www.dmg.org/PMML-4_3", type = Discretize.class),
        @XmlElement(name = "MapValues", namespace = "http://www.dmg.org/PMML-4_3", type = MapValues.class),
        @XmlElement(name = "TextIndex", namespace = "http://www.dmg.org/PMML-4_3", type = TextIndex.class),
        @XmlElement(name = "Apply", namespace = "http://www.dmg.org/PMML-4_3", type = Apply.class),
        @XmlElement(name = "Aggregate", namespace = "http://www.dmg.org/PMML-4_3", type = Aggregate.class),
        @XmlElement(name = "Lag", namespace = "http://www.dmg.org/PMML-4_3", type = Lag.class)
    })
    @Added(Version.PMML_4_1)
    private Expression expression;
    private final static Integer DEFAULT_RANK = 1;
    private final static Boolean DEFAULT_FINAL_RESULT = true;
    private final static long serialVersionUID = 67305473L;

    public OutputField() {
    }

    public OutputField(
        @org.jpmml.model.Property("name")
        FieldName name,
        @org.jpmml.model.Property("dataType")
        DataType dataType) {
        this.name = name;
        this.dataType = dataType;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param name
     *     allowed object is
     *     {@link String }
     *     
     */
    public OutputField setName(
        @org.jpmml.model.Property("name")
        FieldName name) {
        this.name = name;
        return this;
    }

    /**
     * Gets the value of the displayName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDisplayName() {
        return displayName;
    }

    /**
     * Sets the value of the displayName property.
     * 
     * @param displayName
     *     allowed object is
     *     {@link String }
     *     
     */
    public OutputField setDisplayName(
        @org.jpmml.model.Property("displayName")
        String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Gets the value of the opType property.
     * 
     * @return
     *     possible object is
     *     {@link OpType }
     *     
     */
    public OpType getOpType() {
        return opType;
    }

    /**
     * Sets the value of the opType property.
     * 
     * @param opType
     *     allowed object is
     *     {@link OpType }
     *     
     */
    public OutputField setOpType(
        @org.jpmml.model.Property("opType")
        OpType opType) {
        this.opType = opType;
        return this;
    }

    /**
     * Gets the value of the dataType property.
     * 
     * @return
     *     possible object is
     *     {@link DataType }
     *     
     */
    public DataType getDataType() {
        return dataType;
    }

    /**
     * Sets the value of the dataType property.
     * 
     * @param dataType
     *     allowed object is
     *     {@link DataType }
     *     
     */
    public OutputField setDataType(
        @org.jpmml.model.Property("dataType")
        DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    /**
     * Gets the value of the targetField property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getTargetField() {
        return targetField;
    }

    /**
     * Sets the value of the targetField property.
     * 
     * @param targetField
     *     allowed object is
     *     {@link String }
     *     
     */
    public OutputField setTargetField(
        @org.jpmml.model.Property("targetField")
        FieldName targetField) {
        this.targetField = targetField;
        return this;
    }

    /**
     * Gets the value of the resultFeature property.
     * 
     * @return
     *     possible object is
     *     {@link ResultFeature }
     *     
     */
    public ResultFeature getResultFeature() {
        if (resultFeature == null) {
            return ResultFeature.PREDICTED_VALUE;
        } else {
            return resultFeature;
        }
    }

    /**
     * Sets the value of the resultFeature property.
     * 
     * @param resultFeature
     *     allowed object is
     *     {@link ResultFeature }
     *     
     */
    public OutputField setResultFeature(
        @org.jpmml.model.Property("resultFeature")
        ResultFeature resultFeature) {
        this.resultFeature = resultFeature;
        return this;
    }

    /**
     * Gets the value of the value property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public OutputField setValue(
        @org.jpmml.model.Property("value")
        String value) {
        this.value = value;
        return this;
    }

    /**
     * Gets the value of the ruleFeature property.
     * 
     * @return
     *     possible object is
     *     {@link OutputField.RuleFeature }
     *     
     */
    public OutputField.RuleFeature getRuleFeature() {
        if (ruleFeature == null) {
            return OutputField.RuleFeature.CONSEQUENT;
        } else {
            return ruleFeature;
        }
    }

    /**
     * Sets the value of the ruleFeature property.
     * 
     * @param ruleFeature
     *     allowed object is
     *     {@link OutputField.RuleFeature }
     *     
     */
    public OutputField setRuleFeature(
        @org.jpmml.model.Property("ruleFeature")
        OutputField.RuleFeature ruleFeature) {
        this.ruleFeature = ruleFeature;
        return this;
    }

    /**
     * Gets the value of the algorithm property.
     * 
     * @return
     *     possible object is
     *     {@link OutputField.Algorithm }
     *     
     */
    public OutputField.Algorithm getAlgorithm() {
        if (algorithm == null) {
            return OutputField.Algorithm.EXCLUSIVE_RECOMMENDATION;
        } else {
            return algorithm;
        }
    }

    /**
     * Sets the value of the algorithm property.
     * 
     * @param algorithm
     *     allowed object is
     *     {@link OutputField.Algorithm }
     *     
     */
    public OutputField setAlgorithm(
        @org.jpmml.model.Property("algorithm")
        OutputField.Algorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    /**
     * Gets the value of the rank property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getRank() {
        if (rank == null) {
            return DEFAULT_RANK;
        } else {
            return rank;
        }
    }

    /**
     * Sets the value of the rank property.
     * 
     * @param rank
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public OutputField setRank(
        @org.jpmml.model.Property("rank")
        Integer rank) {
        this.rank = rank;
        return this;
    }

    /**
     * Gets the value of the rankBasis property.
     * 
     * @return
     *     possible object is
     *     {@link OutputField.RankBasis }
     *     
     */
    public OutputField.RankBasis getRankBasis() {
        if (rankBasis == null) {
            return OutputField.RankBasis.CONFIDENCE;
        } else {
            return rankBasis;
        }
    }

    /**
     * Sets the value of the rankBasis property.
     * 
     * @param rankBasis
     *     allowed object is
     *     {@link OutputField.RankBasis }
     *     
     */
    public OutputField setRankBasis(
        @org.jpmml.model.Property("rankBasis")
        OutputField.RankBasis rankBasis) {
        this.rankBasis = rankBasis;
        return this;
    }

    /**
     * Gets the value of the rankOrder property.
     * 
     * @return
     *     possible object is
     *     {@link OutputField.RankOrder }
     *     
     */
    public OutputField.RankOrder getRankOrder() {
        if (rankOrder == null) {
            return OutputField.RankOrder.DESCENDING;
        } else {
            return rankOrder;
        }
    }

    /**
     * Sets the value of the rankOrder property.
     * 
     * @param rankOrder
     *     allowed object is
     *     {@link OutputField.RankOrder }
     *     
     */
    public OutputField setRankOrder(
        @org.jpmml.model.Property("rankOrder")
        OutputField.RankOrder rankOrder) {
        this.rankOrder = rankOrder;
        return this;
    }

    /**
     * Gets the value of the isMultiValued property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getIsMultiValued() {
        if (isMultiValued == null) {
            return "0";
        } else {
            return isMultiValued;
        }
    }

    /**
     * Sets the value of the isMultiValued property.
     * 
     * @param isMultiValued
     *     allowed object is
     *     {@link String }
     *     
     */
    public OutputField setIsMultiValued(
        @org.jpmml.model.Property("isMultiValued")
        String isMultiValued) {
        this.isMultiValued = isMultiValued;
        return this;
    }

    /**
     * Gets the value of the segmentId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSegmentId() {
        return segmentId;
    }

    /**
     * Sets the value of the segmentId property.
     * 
     * @param segmentId
     *     allowed object is
     *     {@link String }
     *     
     */
    public OutputField setSegmentId(
        @org.jpmml.model.Property("segmentId")
        String segmentId) {
        this.segmentId = segmentId;
        return this;
    }

    /**
     * Gets the value of the finalResult property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isFinalResult() {
        if (finalResult == null) {
            return DEFAULT_FINAL_RESULT;
        } else {
            return finalResult;
        }
    }

    /**
     * Sets the value of the finalResult property.
     * 
     * @param finalResult
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public OutputField setFinalResult(
        @org.jpmml.model.Property("finalResult")
        Boolean finalResult) {
        this.finalResult = finalResult;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the decisions property.
     * 
     * @return
     *     possible object is
     *     {@link Decisions }
     *     
     */
    public Decisions getDecisions() {
        return decisions;
    }

    /**
     * Sets the value of the decisions property.
     * 
     * @param decisions
     *     allowed object is
     *     {@link Decisions }
     *     
     */
    public OutputField setDecisions(
        @org.jpmml.model.Property("decisions")
        Decisions decisions) {
        this.decisions = decisions;
        return this;
    }

    /**
     * Gets the value of the expression property.
     * 
     * @return
     *     possible object is
     *     {@link Constant }
     *     {@link FieldRef }
     *     {@link NormContinuous }
     *     {@link NormDiscrete }
     *     {@link Discretize }
     *     {@link MapValues }
     *     {@link TextIndex }
     *     {@link Apply }
     *     {@link Aggregate }
     *     {@link Lag }
     *     
     */
    public Expression getExpression() {
        return expression;
    }

    /**
     * Sets the value of the expression property.
     * 
     * @param expression
     *     allowed object is
     *     {@link Constant }
     *     {@link FieldRef }
     *     {@link NormContinuous }
     *     {@link NormDiscrete }
     *     {@link Discretize }
     *     {@link MapValues }
     *     {@link TextIndex }
     *     {@link Apply }
     *     {@link Aggregate }
     *     {@link Lag }
     *     
     */
    public OutputField setExpression(
        @org.jpmml.model.Property("expression")
        Expression expression) {
        this.expression = expression;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public OutputField addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getDecisions(), getExpression());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="recommendation"/>
     *     &lt;enumeration value="exclusiveRecommendation"/>
     *     &lt;enumeration value="ruleAssociation"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    @Added(Version.PMML_4_0)
    public enum Algorithm {

        @XmlEnumValue("recommendation")
        RECOMMENDATION("recommendation"),
        @XmlEnumValue("exclusiveRecommendation")
        EXCLUSIVE_RECOMMENDATION("exclusiveRecommendation"),
        @XmlEnumValue("ruleAssociation")
        RULE_ASSOCIATION("ruleAssociation");
        private final String value;

        Algorithm(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static OutputField.Algorithm fromValue(String v) {
            for (OutputField.Algorithm c: OutputField.Algorithm.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="confidence"/>
     *     &lt;enumeration value="support"/>
     *     &lt;enumeration value="lift"/>
     *     &lt;enumeration value="leverage"/>
     *     &lt;enumeration value="affinity"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    @Added(Version.PMML_4_0)
    public enum RankBasis {

        @XmlEnumValue("confidence")
        CONFIDENCE("confidence"),
        @XmlEnumValue("support")
        SUPPORT("support"),
        @XmlEnumValue("lift")
        LIFT("lift"),
        @XmlEnumValue("leverage")
        @Added(Version.PMML_4_1)
        LEVERAGE("leverage"),
        @XmlEnumValue("affinity")
        @Added(Version.PMML_4_1)
        AFFINITY("affinity");
        private final String value;

        RankBasis(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static OutputField.RankBasis fromValue(String v) {
            for (OutputField.RankBasis c: OutputField.RankBasis.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="descending"/>
     *     &lt;enumeration value="ascending"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    @Added(Version.PMML_4_0)
    public enum RankOrder {

        @XmlEnumValue("descending")
        DESCENDING("descending"),
        @XmlEnumValue("ascending")
        ASCENDING("ascending");
        private final String value;

        RankOrder(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static OutputField.RankOrder fromValue(String v) {
            for (OutputField.RankOrder c: OutputField.RankOrder.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="antecedent"/>
     *     &lt;enumeration value="consequent"/>
     *     &lt;enumeration value="rule"/>
     *     &lt;enumeration value="ruleId"/>
     *     &lt;enumeration value="confidence"/>
     *     &lt;enumeration value="support"/>
     *     &lt;enumeration value="lift"/>
     *     &lt;enumeration value="leverage"/>
     *     &lt;enumeration value="affinity"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    @Added(Version.PMML_4_0)
    public enum RuleFeature {

        @XmlEnumValue("antecedent")
        ANTECEDENT("antecedent"),
        @XmlEnumValue("consequent")
        CONSEQUENT("consequent"),
        @XmlEnumValue("rule")
        RULE("rule"),
        @XmlEnumValue("ruleId")
        RULE_ID("ruleId"),
        @XmlEnumValue("confidence")
        CONFIDENCE("confidence"),
        @XmlEnumValue("support")
        SUPPORT("support"),
        @XmlEnumValue("lift")
        LIFT("lift"),
        @XmlEnumValue("leverage")
        @Added(Version.PMML_4_1)
        LEVERAGE("leverage"),
        @XmlEnumValue("affinity")
        @Added(Version.PMML_4_1)
        AFFINITY("affinity");
        private final String value;

        RuleFeature(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static OutputField.RuleFeature fromValue(String v) {
            for (OutputField.RuleFeature c: OutputField.RuleFeature.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
