/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Indexable;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions"})
@XmlRootElement(name="Value", namespace="http://www.dmg.org/PMML-4_3")
public class Value
extends PMMLObject
implements HasExtensions<Value>,
Indexable<String> {
    @XmlAttribute(name="value", required=true)
    private String value;
    @XmlAttribute(name="displayValue")
    private String displayValue;
    @XmlAttribute(name="property")
    private Property property;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    private static final long serialVersionUID = 67305473L;

    public Value() {
    }

    public Value(@org.jpmml.model.Property(value="value") String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public Value setValue(@org.jpmml.model.Property(value="value") String value) {
        this.value = value;
        return this;
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public Value setDisplayValue(@org.jpmml.model.Property(value="displayValue") String displayValue) {
        this.displayValue = displayValue;
        return this;
    }

    public Property getProperty() {
        if (this.property == null) {
            return Property.VALID;
        }
        return this.property;
    }

    public Value setProperty(@org.jpmml.model.Property(value="property") Property property) {
        this.property = property;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public String getKey() {
        return this.getValue();
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public Value addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Property {
        VALID("valid"),
        INVALID("invalid"),
        MISSING("missing");

        private final String value;

        private Property(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static Property fromValue(String v) {
            for (Property c : Property.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

