
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Decision" maxOccurs="unbounded"/>
 *       &lt;/sequence>
 *       &lt;attribute name="businessProblem" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="description" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "decisions"
})
@XmlRootElement(name = "Decisions", namespace = "http://www.dmg.org/PMML-4_3")
@Added(Version.PMML_4_1)
public class Decisions
    extends org.dmg.pmml.PMMLObject
    implements Iterable<Decision> , HasExtensions<Decisions>
{

    @XmlAttribute(name = "businessProblem")
    private String businessProblem;
    @XmlAttribute(name = "description")
    private String description;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "Decision", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<Decision> decisions;
    private final static long serialVersionUID = 67305475L;

    public Decisions() {
    }

    public Decisions(
        @org.jpmml.model.Property("decisions")
        List<Decision> decisions) {
        this.decisions = decisions;
    }

    /**
     * Gets the value of the businessProblem property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBusinessProblem() {
        return businessProblem;
    }

    /**
     * Sets the value of the businessProblem property.
     * 
     * @param businessProblem
     *     allowed object is
     *     {@link String }
     *     
     */
    public Decisions setBusinessProblem(
        @org.jpmml.model.Property("businessProblem")
        String businessProblem) {
        this.businessProblem = businessProblem;
        return this;
    }

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param description
     *     allowed object is
     *     {@link String }
     *     
     */
    public Decisions setDescription(
        @org.jpmml.model.Property("description")
        String description) {
        this.description = description;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the decisions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the decisions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDecisions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Decision }
     * 
     * 
     */
    public List<Decision> getDecisions() {
        if (decisions == null) {
            decisions = new ArrayList<Decision>();
        }
        return this.decisions;
    }

    public Iterator<Decision> iterator() {
        return getDecisions().iterator();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Decisions addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasDecisions() {
        return ((this.decisions!= null)&&(this.decisions.size()> 0));
    }

    public Decisions addDecisions(Decision... decisions) {
        getDecisions().addAll(Arrays.asList(decisions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasDecisions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getDecisions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
