
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Array"/>
 *       &lt;/sequence>
 *       &lt;attribute name="field" use="required" type="{http://www.dmg.org/PMML-4_3}FIELD-NAME" />
 *       &lt;attribute name="booleanOperator" use="required">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="isIn"/>
 *             &lt;enumeration value="isNotIn"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "array"
})
@XmlRootElement(name = "SimpleSetPredicate", namespace = "http://www.dmg.org/PMML-4_3")
public class SimpleSetPredicate
    extends Predicate
    implements HasExtensions<SimpleSetPredicate> , HasValueSet<SimpleSetPredicate>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName field;
    @XmlAttribute(name = "booleanOperator", required = true)
    private SimpleSetPredicate.BooleanOperator booleanOperator;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private Array array;
    private final static long serialVersionUID = 67305475L;

    public SimpleSetPredicate() {
    }

    public SimpleSetPredicate(
        @org.jpmml.model.Property("field")
        FieldName field,
        @org.jpmml.model.Property("booleanOperator")
        SimpleSetPredicate.BooleanOperator booleanOperator,
        @org.jpmml.model.Property("array")
        Array array) {
        this.field = field;
        this.booleanOperator = booleanOperator;
        this.array = array;
    }

    /**
     * Gets the value of the field property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getField() {
        return field;
    }

    /**
     * Sets the value of the field property.
     * 
     * @param field
     *     allowed object is
     *     {@link String }
     *     
     */
    public SimpleSetPredicate setField(
        @org.jpmml.model.Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    /**
     * Gets the value of the booleanOperator property.
     * 
     * @return
     *     possible object is
     *     {@link SimpleSetPredicate.BooleanOperator }
     *     
     */
    public SimpleSetPredicate.BooleanOperator getBooleanOperator() {
        return booleanOperator;
    }

    /**
     * Sets the value of the booleanOperator property.
     * 
     * @param booleanOperator
     *     allowed object is
     *     {@link SimpleSetPredicate.BooleanOperator }
     *     
     */
    public SimpleSetPredicate setBooleanOperator(
        @org.jpmml.model.Property("booleanOperator")
        SimpleSetPredicate.BooleanOperator booleanOperator) {
        this.booleanOperator = booleanOperator;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the array property.
     * 
     * @return
     *     possible object is
     *     {@link Array }
     *     
     */
    public Array getArray() {
        return array;
    }

    /**
     * Sets the value of the array property.
     * 
     * @param array
     *     allowed object is
     *     {@link Array }
     *     
     */
    public SimpleSetPredicate setArray(
        @org.jpmml.model.Property("array")
        Array array) {
        this.array = array;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public SimpleSetPredicate addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getArray());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="isIn"/>
     *     &lt;enumeration value="isNotIn"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum BooleanOperator {

        @XmlEnumValue("isIn")
        IS_IN("isIn"),
        @XmlEnumValue("isNotIn")
        IS_NOT_IN("isNotIn");
        private final String value;

        BooleanOperator(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static SimpleSetPredicate.BooleanOperator fromValue(String v) {
            for (SimpleSetPredicate.BooleanOperator c: SimpleSetPredicate.BooleanOperator.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
