
package org.dmg.pmml.baseline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.DiscreteDistribution;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.Property;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for COUNT-TABLE-TYPE complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="COUNT-TABLE-TYPE">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;choice>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_3}FieldValue" maxOccurs="unbounded"/>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_3}FieldValueCount" maxOccurs="unbounded"/>
 *         &lt;/choice>
 *       &lt;/sequence>
 *       &lt;attribute name="sample" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "COUNT-TABLE-TYPE", namespace = "http://www.dmg.org/PMML-4_3", propOrder = {
    "extensions",
    "fieldValues",
    "fieldValueCounts"
})
@Added(Version.PMML_4_1)
public class CountTable
    extends DiscreteDistribution
    implements HasExtensions<CountTable>
{

    @XmlAttribute(name = "sample")
    private Double sample;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "FieldValue", namespace = "http://www.dmg.org/PMML-4_3")
    private List<FieldValue> fieldValues;
    @XmlElement(name = "FieldValueCount", namespace = "http://www.dmg.org/PMML-4_3")
    private List<FieldValueCount> fieldValueCounts;
    private final static long serialVersionUID = 67305475L;

    /**
     * Gets the value of the sample property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getSample() {
        return sample;
    }

    /**
     * Sets the value of the sample property.
     * 
     * @param sample
     *     allowed object is
     *     {@link Double }
     *     
     */
    public CountTable setSample(
        @Property("sample")
        Double sample) {
        this.sample = sample;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the fieldValues property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the fieldValues property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFieldValues().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FieldValue }
     * 
     * 
     */
    public List<FieldValue> getFieldValues() {
        if (fieldValues == null) {
            fieldValues = new ArrayList<FieldValue>();
        }
        return this.fieldValues;
    }

    /**
     * Gets the value of the fieldValueCounts property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the fieldValueCounts property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFieldValueCounts().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FieldValueCount }
     * 
     * 
     */
    public List<FieldValueCount> getFieldValueCounts() {
        if (fieldValueCounts == null) {
            fieldValueCounts = new ArrayList<FieldValueCount>();
        }
        return this.fieldValueCounts;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public CountTable addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasFieldValues() {
        return ((this.fieldValues!= null)&&(this.fieldValues.size()> 0));
    }

    public CountTable addFieldValues(FieldValue... fieldValues) {
        getFieldValues().addAll(Arrays.asList(fieldValues));
        return this;
    }

    public boolean hasFieldValueCounts() {
        return ((this.fieldValueCounts!= null)&&(this.fieldValueCounts.size()> 0));
    }

    public CountTable addFieldValueCounts(FieldValueCount... fieldValueCounts) {
        getFieldValueCounts().addAll(Arrays.asList(fieldValueCounts));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasFieldValues()) {
                status = PMMLObject.traverse(visitor, getFieldValues());
            }
            if ((status == VisitorAction.CONTINUE)&&hasFieldValueCounts()) {
                status = PMMLObject.traverse(visitor, getFieldValueCounts());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
