
package org.dmg.pmml.support_vector_machine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}SupportVector" maxOccurs="unbounded"/>
 *       &lt;/sequence>
 *       &lt;attribute name="numberOfSupportVectors" type="{http://www.dmg.org/PMML-4_3}INT-NUMBER" />
 *       &lt;attribute name="numberOfAttributes" type="{http://www.dmg.org/PMML-4_3}INT-NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "supportVectors"
})
@XmlRootElement(name = "SupportVectors", namespace = "http://www.dmg.org/PMML-4_3")
public class SupportVectors
    extends org.dmg.pmml.PMMLObject
    implements Iterable<SupportVector> , HasExtensions<SupportVectors>
{

    @XmlAttribute(name = "numberOfSupportVectors")
    private Integer numberOfSupportVectors;
    @XmlAttribute(name = "numberOfAttributes")
    private Integer numberOfAttributes;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "SupportVector", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<SupportVector> supportVectors;
    private final static long serialVersionUID = 67305475L;

    public SupportVectors() {
    }

    public SupportVectors(
        @org.jpmml.model.Property("supportVectors")
        List<SupportVector> supportVectors) {
        this.supportVectors = supportVectors;
    }

    /**
     * Gets the value of the numberOfSupportVectors property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getNumberOfSupportVectors() {
        return numberOfSupportVectors;
    }

    /**
     * Sets the value of the numberOfSupportVectors property.
     * 
     * @param numberOfSupportVectors
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public SupportVectors setNumberOfSupportVectors(
        @org.jpmml.model.Property("numberOfSupportVectors")
        Integer numberOfSupportVectors) {
        this.numberOfSupportVectors = numberOfSupportVectors;
        return this;
    }

    /**
     * Gets the value of the numberOfAttributes property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getNumberOfAttributes() {
        return numberOfAttributes;
    }

    /**
     * Sets the value of the numberOfAttributes property.
     * 
     * @param numberOfAttributes
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public SupportVectors setNumberOfAttributes(
        @org.jpmml.model.Property("numberOfAttributes")
        Integer numberOfAttributes) {
        this.numberOfAttributes = numberOfAttributes;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the supportVectors property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the supportVectors property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSupportVectors().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SupportVector }
     * 
     * 
     */
    public List<SupportVector> getSupportVectors() {
        if (supportVectors == null) {
            supportVectors = new ArrayList<SupportVector>();
        }
        return this.supportVectors;
    }

    public Iterator<SupportVector> iterator() {
        return getSupportVectors().iterator();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public SupportVectors addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasSupportVectors() {
        return ((this.supportVectors!= null)&&(this.supportVectors.size()> 0));
    }

    public SupportVectors addSupportVectors(SupportVector... supportVectors) {
        getSupportVectors().addAll(Arrays.asList(supportVectors));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasSupportVectors()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getSupportVectors());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
