
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Level"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Trend_ExpoSmooth" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Seasonality_ExpoSmooth" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}TimeValue" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="RMSE" type="{http://www.dmg.org/PMML-4_3}REAL-NUMBER" />
 *       &lt;attribute name="transformation" default="none">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}NMTOKEN">
 *             &lt;enumeration value="none"/>
 *             &lt;enumeration value="logarithmic"/>
 *             &lt;enumeration value="squareroot"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "level",
    "trendExpoSmooth",
    "seasonalityExpoSmooth",
    "timeValues"
})
@XmlRootElement(name = "ExponentialSmoothing", namespace = "http://www.dmg.org/PMML-4_3")
@Added(Version.PMML_4_0)
public class ExponentialSmoothing
    extends TimeSeriesAlgorithm
{

    @XmlAttribute(name = "RMSE")
    private Double rmse;
    @XmlAttribute(name = "transformation")
    private ExponentialSmoothing.Transformation transformation;
    @XmlElement(name = "Level", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private Level level;
    @XmlElement(name = "Trend_ExpoSmooth", namespace = "http://www.dmg.org/PMML-4_3")
    private TrendExpoSmooth trendExpoSmooth;
    @XmlElement(name = "Seasonality_ExpoSmooth", namespace = "http://www.dmg.org/PMML-4_3")
    private SeasonalityExpoSmooth seasonalityExpoSmooth;
    @XmlElement(name = "TimeValue", namespace = "http://www.dmg.org/PMML-4_3")
    private List<TimeValue> timeValues;
    private final static long serialVersionUID = 67305475L;

    public ExponentialSmoothing() {
    }

    public ExponentialSmoothing(
        @org.jpmml.model.Property("level")
        Level level) {
        this.level = level;
    }

    /**
     * Gets the value of the rmse property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getRMSE() {
        return rmse;
    }

    /**
     * Sets the value of the rmse property.
     * 
     * @param rmse
     *     allowed object is
     *     {@link Double }
     *     
     */
    public ExponentialSmoothing setRMSE(
        @org.jpmml.model.Property("rmse")
        Double rmse) {
        this.rmse = rmse;
        return this;
    }

    /**
     * Gets the value of the transformation property.
     * 
     * @return
     *     possible object is
     *     {@link ExponentialSmoothing.Transformation }
     *     
     */
    public ExponentialSmoothing.Transformation getTransformation() {
        if (transformation == null) {
            return ExponentialSmoothing.Transformation.NONE;
        } else {
            return transformation;
        }
    }

    /**
     * Sets the value of the transformation property.
     * 
     * @param transformation
     *     allowed object is
     *     {@link ExponentialSmoothing.Transformation }
     *     
     */
    public ExponentialSmoothing setTransformation(
        @org.jpmml.model.Property("transformation")
        ExponentialSmoothing.Transformation transformation) {
        this.transformation = transformation;
        return this;
    }

    /**
     * Gets the value of the level property.
     * 
     * @return
     *     possible object is
     *     {@link Level }
     *     
     */
    public Level getLevel() {
        return level;
    }

    /**
     * Sets the value of the level property.
     * 
     * @param level
     *     allowed object is
     *     {@link Level }
     *     
     */
    public ExponentialSmoothing setLevel(
        @org.jpmml.model.Property("level")
        Level level) {
        this.level = level;
        return this;
    }

    /**
     * Gets the value of the trendExpoSmooth property.
     * 
     * @return
     *     possible object is
     *     {@link TrendExpoSmooth }
     *     
     */
    public TrendExpoSmooth getTrendExpoSmooth() {
        return trendExpoSmooth;
    }

    /**
     * Sets the value of the trendExpoSmooth property.
     * 
     * @param trendExpoSmooth
     *     allowed object is
     *     {@link TrendExpoSmooth }
     *     
     */
    public ExponentialSmoothing setTrendExpoSmooth(
        @org.jpmml.model.Property("trendExpoSmooth")
        TrendExpoSmooth trendExpoSmooth) {
        this.trendExpoSmooth = trendExpoSmooth;
        return this;
    }

    /**
     * Gets the value of the seasonalityExpoSmooth property.
     * 
     * @return
     *     possible object is
     *     {@link SeasonalityExpoSmooth }
     *     
     */
    public SeasonalityExpoSmooth getSeasonalityExpoSmooth() {
        return seasonalityExpoSmooth;
    }

    /**
     * Sets the value of the seasonalityExpoSmooth property.
     * 
     * @param seasonalityExpoSmooth
     *     allowed object is
     *     {@link SeasonalityExpoSmooth }
     *     
     */
    public ExponentialSmoothing setSeasonalityExpoSmooth(
        @org.jpmml.model.Property("seasonalityExpoSmooth")
        SeasonalityExpoSmooth seasonalityExpoSmooth) {
        this.seasonalityExpoSmooth = seasonalityExpoSmooth;
        return this;
    }

    /**
     * Gets the value of the timeValues property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the timeValues property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTimeValues().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TimeValue }
     * 
     * 
     */
    public List<TimeValue> getTimeValues() {
        if (timeValues == null) {
            timeValues = new ArrayList<TimeValue>();
        }
        return this.timeValues;
    }

    public boolean hasTimeValues() {
        return ((this.timeValues!= null)&&(this.timeValues.size()> 0));
    }

    public ExponentialSmoothing addTimeValues(TimeValue... timeValues) {
        getTimeValues().addAll(Arrays.asList(timeValues));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getLevel(), getTrendExpoSmooth(), getSeasonalityExpoSmooth());
            }
            if ((status == VisitorAction.CONTINUE)&&hasTimeValues()) {
                status = PMMLObject.traverse(visitor, getTimeValues());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}NMTOKEN">
     *     &lt;enumeration value="none"/>
     *     &lt;enumeration value="logarithmic"/>
     *     &lt;enumeration value="squareroot"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum Transformation {

        @XmlEnumValue("none")
        NONE("none"),
        @XmlEnumValue("logarithmic")
        LOGARITHMIC("logarithmic"),
        @XmlEnumValue("squareroot")
        SQUAREROOT("squareroot");
        private final String value;

        Transformation(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static ExponentialSmoothing.Transformation fromValue(String v) {
            for (ExponentialSmoothing.Transformation c: ExponentialSmoothing.Transformation.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
