/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.visitors;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segment;
import org.dmg.pmml.mining.Segmentation;
import org.jpmml.model.FieldUtil;
import org.jpmml.model.visitors.DeepFieldResolver;
import org.jpmml.model.visitors.DeepFieldResolverUtil;
import org.jpmml.model.visitors.FieldDependencyResolver;

public class MiningSchemaCleaner
extends DeepFieldResolver {
    @Override
    public PMMLObject popParent() {
        PMMLObject parent = super.popParent();
        if (parent instanceof MiningModel) {
            MiningModel miningModel = (MiningModel)parent;
            Set<FieldName> activeFieldNames = this.processMiningModel(miningModel);
            this.clean(miningModel, activeFieldNames);
        } else if (parent instanceof Model) {
            Model model = (Model)parent;
            Set<FieldName> activeFieldNames = this.processModel(model);
            this.clean(model, activeFieldNames);
        }
        return parent;
    }

    private Set<FieldName> processMiningModel(MiningModel miningModel) {
        Set<Field> activeFields = DeepFieldResolverUtil.getActiveFields((DeepFieldResolver)this, miningModel);
        HashSet<FieldName> activeFieldNames = new HashSet<FieldName>();
        Segmentation segmentation = miningModel.getSegmentation();
        List<Segment> segments = segmentation.getSegments();
        for (Segment segment : segments) {
            Model model = segment.getModel();
            if (model == null) continue;
            MiningSchema miningSchema = model.getMiningSchema();
            List<MiningField> miningFields = miningSchema.getMiningFields();
            for (MiningField miningField : miningFields) {
                FieldName name = miningField.getName();
                MiningField.UsageType usageType = miningField.getUsageType();
                switch (usageType) {
                    case ACTIVE: {
                        activeFieldNames.add(name);
                        break;
                    }
                }
            }
        }
        Set<Field> modelFields = this.getFields(miningModel);
        Set<Field> activeModelFields = FieldUtil.selectAll(modelFields, activeFieldNames, true);
        activeFields.addAll(activeModelFields);
        this.expandDerivedFields(miningModel, activeFields);
        return FieldUtil.nameSet(activeFields);
    }

    private Set<FieldName> processModel(Model model) {
        Set<Field> activeFields = DeepFieldResolverUtil.getActiveFields((DeepFieldResolver)this, model);
        this.expandDerivedFields(model, activeFields);
        return FieldUtil.nameSet(activeFields);
    }

    private void expandDerivedFields(Model model, Set<Field> fields) {
        FieldDependencyResolver fieldDependencyResolver = this.getFieldDependencyResolver();
        fieldDependencyResolver.expand(fields, fieldDependencyResolver.getGlobalDerivedFields());
        LocalTransformations localTransformations = model.getLocalTransformations();
        if (localTransformations != null && localTransformations.hasDerivedFields()) {
            fieldDependencyResolver.expand(fields, new HashSet<DerivedField>(localTransformations.getDerivedFields()));
        }
    }

    private void clean(Model model, Set<FieldName> activeFieldNames) {
        MiningSchema miningSchema = model.getMiningSchema();
        activeFieldNames = new LinkedHashSet<FieldName>(activeFieldNames);
        List<MiningField> miningFields = miningSchema.getMiningFields();
        Iterator<MiningField> it = miningFields.iterator();
        while (it.hasNext()) {
            MiningField miningField = it.next();
            FieldName name = miningField.getName();
            MiningField.UsageType usageType = miningField.getUsageType();
            switch (usageType) {
                case ACTIVE: {
                    if (activeFieldNames.contains(name)) break;
                    it.remove();
                    break;
                }
            }
            activeFieldNames.remove(name);
        }
        for (FieldName activeFieldName : activeFieldNames) {
            MiningField miningField = new MiningField(activeFieldName);
            miningSchema.addMiningFields(miningField);
        }
    }
}

