
package org.dmg.pmml.neural_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ModelExplanation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Targets" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}NeuralInputs"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}NeuralLayer" maxOccurs="unbounded"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}NeuralOutputs" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_3}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="activationFunction" use="required">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="threshold"/>
 *             &lt;enumeration value="logistic"/>
 *             &lt;enumeration value="tanh"/>
 *             &lt;enumeration value="identity"/>
 *             &lt;enumeration value="exponential"/>
 *             &lt;enumeration value="reciprocal"/>
 *             &lt;enumeration value="square"/>
 *             &lt;enumeration value="Gauss"/>
 *             &lt;enumeration value="sine"/>
 *             &lt;enumeration value="cosine"/>
 *             &lt;enumeration value="Elliott"/>
 *             &lt;enumeration value="arctan"/>
 *             &lt;enumeration value="rectifier"/>
 *             &lt;enumeration value="radialBasis"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="normalizationMethod" default="none">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="none"/>
 *             &lt;enumeration value="simplemax"/>
 *             &lt;enumeration value="softmax"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="threshold" type="{http://www.dmg.org/PMML-4_3}REAL-NUMBER" default="0" />
 *       &lt;attribute name="width" type="{http://www.dmg.org/PMML-4_3}REAL-NUMBER" />
 *       &lt;attribute name="altitude" type="{http://www.dmg.org/PMML-4_3}REAL-NUMBER" default="1.0" />
 *       &lt;attribute name="numberOfLayers" type="{http://www.dmg.org/PMML-4_3}INT-NUMBER" />
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       &lt;attribute name="x-mathContext" type="{http://www.dmg.org/PMML-4_3}MATH-CONTEXT" default="double" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "neuralInputs",
    "neuralLayers",
    "neuralOutputs",
    "modelVerification"
})
@XmlRootElement(name = "NeuralNetwork", namespace = "http://www.dmg.org/PMML-4_3")
public class NeuralNetwork
    extends Model
    implements HasExtensions<NeuralNetwork>
{

    @XmlAttribute(name = "modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "activationFunction", required = true)
    private NeuralNetwork.ActivationFunction activationFunction;
    @XmlAttribute(name = "normalizationMethod")
    private NeuralNetwork.NormalizationMethod normalizationMethod;
    @XmlAttribute(name = "threshold")
    private Double threshold;
    @XmlAttribute(name = "width")
    private Double width;
    @XmlAttribute(name = "altitude")
    private Double altitude;
    @XmlAttribute(name = "numberOfLayers")
    private Integer numberOfLayers;
    @XmlAttribute(name = "isScorable")
    @Added(Version.PMML_4_1)
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @org.jpmml.schema.Extension
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<org.dmg.pmml.Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_3")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_3")
    @Added(Version.PMML_4_0)
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_3")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_3")
    private LocalTransformations localTransformations;
    @XmlElement(name = "NeuralInputs", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private NeuralInputs neuralInputs;
    @XmlElement(name = "NeuralLayer", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<NeuralLayer> neuralLayers;
    @XmlElement(name = "NeuralOutputs", namespace = "http://www.dmg.org/PMML-4_3")
    private NeuralOutputs neuralOutputs;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelVerification modelVerification;
    private final static Double DEFAULT_THRESHOLD = 0.0D;
    private final static Double DEFAULT_ALTITUDE = 1.0D;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67305478L;

    public NeuralNetwork() {
    }

    public NeuralNetwork(
        @org.jpmml.model.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.Property("activationFunction")
        NeuralNetwork.ActivationFunction activationFunction,
        @org.jpmml.model.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.Property("neuralInputs")
        NeuralInputs neuralInputs,
        @org.jpmml.model.Property("neuralLayers")
        List<NeuralLayer> neuralLayers) {
        this.miningFunction = miningFunction;
        this.activationFunction = activationFunction;
        this.miningSchema = miningSchema;
        this.neuralInputs = neuralInputs;
        this.neuralLayers = neuralLayers;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param modelName
     *     allowed object is
     *     {@link String }
     *     
     */
    public NeuralNetwork setModelName(
        @org.jpmml.model.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    /**
     * Gets the value of the miningFunction property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunction }
     *     
     */
    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    /**
     * Sets the value of the miningFunction property.
     * 
     * @param miningFunction
     *     allowed object is
     *     {@link MiningFunction }
     *     
     */
    public NeuralNetwork setMiningFunction(
        @org.jpmml.model.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param algorithmName
     *     allowed object is
     *     {@link String }
     *     
     */
    public NeuralNetwork setAlgorithmName(
        @org.jpmml.model.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    /**
     * Gets the value of the activationFunction property.
     * 
     * @return
     *     possible object is
     *     {@link NeuralNetwork.ActivationFunction }
     *     
     */
    public NeuralNetwork.ActivationFunction getActivationFunction() {
        return activationFunction;
    }

    /**
     * Sets the value of the activationFunction property.
     * 
     * @param activationFunction
     *     allowed object is
     *     {@link NeuralNetwork.ActivationFunction }
     *     
     */
    public NeuralNetwork setActivationFunction(
        @org.jpmml.model.Property("activationFunction")
        NeuralNetwork.ActivationFunction activationFunction) {
        this.activationFunction = activationFunction;
        return this;
    }

    /**
     * Gets the value of the normalizationMethod property.
     * 
     * @return
     *     possible object is
     *     {@link NeuralNetwork.NormalizationMethod }
     *     
     */
    public NeuralNetwork.NormalizationMethod getNormalizationMethod() {
        if (normalizationMethod == null) {
            return NeuralNetwork.NormalizationMethod.NONE;
        } else {
            return normalizationMethod;
        }
    }

    /**
     * Sets the value of the normalizationMethod property.
     * 
     * @param normalizationMethod
     *     allowed object is
     *     {@link NeuralNetwork.NormalizationMethod }
     *     
     */
    public NeuralNetwork setNormalizationMethod(
        @org.jpmml.model.Property("normalizationMethod")
        NeuralNetwork.NormalizationMethod normalizationMethod) {
        this.normalizationMethod = normalizationMethod;
        return this;
    }

    /**
     * Gets the value of the threshold property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getThreshold() {
        if (threshold == null) {
            return DEFAULT_THRESHOLD;
        } else {
            return threshold;
        }
    }

    /**
     * Sets the value of the threshold property.
     * 
     * @param threshold
     *     allowed object is
     *     {@link Double }
     *     
     */
    public NeuralNetwork setThreshold(
        @org.jpmml.model.Property("threshold")
        Double threshold) {
        this.threshold = threshold;
        return this;
    }

    /**
     * Gets the value of the width property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getWidth() {
        return width;
    }

    /**
     * Sets the value of the width property.
     * 
     * @param width
     *     allowed object is
     *     {@link Double }
     *     
     */
    public NeuralNetwork setWidth(
        @org.jpmml.model.Property("width")
        Double width) {
        this.width = width;
        return this;
    }

    /**
     * Gets the value of the altitude property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getAltitude() {
        if (altitude == null) {
            return DEFAULT_ALTITUDE;
        } else {
            return altitude;
        }
    }

    /**
     * Sets the value of the altitude property.
     * 
     * @param altitude
     *     allowed object is
     *     {@link Double }
     *     
     */
    public NeuralNetwork setAltitude(
        @org.jpmml.model.Property("altitude")
        Double altitude) {
        this.altitude = altitude;
        return this;
    }

    /**
     * Gets the value of the numberOfLayers property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getNumberOfLayers() {
        return numberOfLayers;
    }

    /**
     * Sets the value of the numberOfLayers property.
     * 
     * @param numberOfLayers
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public NeuralNetwork setNumberOfLayers(
        @org.jpmml.model.Property("numberOfLayers")
        Integer numberOfLayers) {
        this.numberOfLayers = numberOfLayers;
        return this;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param scorable
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public NeuralNetwork setScorable(
        @org.jpmml.model.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    /**
     * Gets the value of the mathContext property.
     * 
     * @return
     *     possible object is
     *     {@link MathContext }
     *     
     */
    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    /**
     * Sets the value of the mathContext property.
     * 
     * @param mathContext
     *     allowed object is
     *     {@link MathContext }
     *     
     */
    public NeuralNetwork setMathContext(
        @org.jpmml.model.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link org.dmg.pmml.Extension }
     * 
     * 
     */
    public List<org.dmg.pmml.Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<org.dmg.pmml.Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param miningSchema
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public NeuralNetwork setMiningSchema(
        @org.jpmml.model.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param output
     *     allowed object is
     *     {@link Output }
     *     
     */
    public NeuralNetwork setOutput(
        @org.jpmml.model.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param modelStats
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public NeuralNetwork setModelStats(
        @org.jpmml.model.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    /**
     * Gets the value of the modelExplanation property.
     * 
     * @return
     *     possible object is
     *     {@link ModelExplanation }
     *     
     */
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    /**
     * Sets the value of the modelExplanation property.
     * 
     * @param modelExplanation
     *     allowed object is
     *     {@link ModelExplanation }
     *     
     */
    public NeuralNetwork setModelExplanation(
        @org.jpmml.model.Property("modelExplanation")
        ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @return
     *     possible object is
     *     {@link Targets }
     *     
     */
    public Targets getTargets() {
        return targets;
    }

    /**
     * Sets the value of the targets property.
     * 
     * @param targets
     *     allowed object is
     *     {@link Targets }
     *     
     */
    public NeuralNetwork setTargets(
        @org.jpmml.model.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param localTransformations
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public NeuralNetwork setLocalTransformations(
        @org.jpmml.model.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    /**
     * Gets the value of the neuralInputs property.
     * 
     * @return
     *     possible object is
     *     {@link NeuralInputs }
     *     
     */
    public NeuralInputs getNeuralInputs() {
        return neuralInputs;
    }

    /**
     * Sets the value of the neuralInputs property.
     * 
     * @param neuralInputs
     *     allowed object is
     *     {@link NeuralInputs }
     *     
     */
    public NeuralNetwork setNeuralInputs(
        @org.jpmml.model.Property("neuralInputs")
        NeuralInputs neuralInputs) {
        this.neuralInputs = neuralInputs;
        return this;
    }

    /**
     * Gets the value of the neuralLayers property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the neuralLayers property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNeuralLayers().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NeuralLayer }
     * 
     * 
     */
    public List<NeuralLayer> getNeuralLayers() {
        if (neuralLayers == null) {
            neuralLayers = new ArrayList<NeuralLayer>();
        }
        return this.neuralLayers;
    }

    /**
     * Gets the value of the neuralOutputs property.
     * 
     * @return
     *     possible object is
     *     {@link NeuralOutputs }
     *     
     */
    public NeuralOutputs getNeuralOutputs() {
        return neuralOutputs;
    }

    /**
     * Sets the value of the neuralOutputs property.
     * 
     * @param neuralOutputs
     *     allowed object is
     *     {@link NeuralOutputs }
     *     
     */
    public NeuralNetwork setNeuralOutputs(
        @org.jpmml.model.Property("neuralOutputs")
        NeuralOutputs neuralOutputs) {
        this.neuralOutputs = neuralOutputs;
        return this;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param modelVerification
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public NeuralNetwork setModelVerification(
        @org.jpmml.model.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public NeuralNetwork addExtensions(org.dmg.pmml.Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasNeuralLayers() {
        return ((this.neuralLayers!= null)&&(this.neuralLayers.size()> 0));
    }

    public NeuralNetwork addNeuralLayers(NeuralLayer... neuralLayers) {
        getNeuralLayers().addAll(Arrays.asList(neuralLayers));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations(), getNeuralInputs());
            }
            if ((status == VisitorAction.CONTINUE)&&hasNeuralLayers()) {
                status = PMMLObject.traverse(visitor, getNeuralLayers());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getNeuralOutputs(), getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="threshold"/>
     *     &lt;enumeration value="logistic"/>
     *     &lt;enumeration value="tanh"/>
     *     &lt;enumeration value="identity"/>
     *     &lt;enumeration value="exponential"/>
     *     &lt;enumeration value="reciprocal"/>
     *     &lt;enumeration value="square"/>
     *     &lt;enumeration value="Gauss"/>
     *     &lt;enumeration value="sine"/>
     *     &lt;enumeration value="cosine"/>
     *     &lt;enumeration value="Elliott"/>
     *     &lt;enumeration value="arctan"/>
     *     &lt;enumeration value="rectifier"/>
     *     &lt;enumeration value="radialBasis"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum ActivationFunction {

        @XmlEnumValue("threshold")
        THRESHOLD("threshold"),
        @XmlEnumValue("logistic")
        LOGISTIC("logistic"),
        @XmlEnumValue("tanh")
        TANH("tanh"),
        @XmlEnumValue("identity")
        IDENTITY("identity"),
        @XmlEnumValue("exponential")
        EXPONENTIAL("exponential"),
        @XmlEnumValue("reciprocal")
        RECIPROCAL("reciprocal"),
        @XmlEnumValue("square")
        SQUARE("square"),
        @XmlEnumValue("Gauss")
        GAUSS("Gauss"),
        @XmlEnumValue("sine")
        SINE("sine"),
        @XmlEnumValue("cosine")
        COSINE("cosine"),
        @XmlEnumValue("Elliott")
        ELLIOTT("Elliott"),
        @XmlEnumValue("arctan")
        ARCTAN("arctan"),
        @XmlEnumValue("rectifier")
        @Added(Version.PMML_4_3)
        RECTIFIER("rectifier"),
        @XmlEnumValue("radialBasis")
        RADIAL_BASIS("radialBasis");
        private final String value;

        ActivationFunction(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static NeuralNetwork.ActivationFunction fromValue(String v) {
            for (NeuralNetwork.ActivationFunction c: NeuralNetwork.ActivationFunction.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="none"/>
     *     &lt;enumeration value="simplemax"/>
     *     &lt;enumeration value="softmax"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum NormalizationMethod {

        @XmlEnumValue("none")
        NONE("none"),
        @XmlEnumValue("simplemax")
        SIMPLEMAX("simplemax"),
        @XmlEnumValue("softmax")
        SOFTMAX("softmax");
        private final String value;

        NormalizationMethod(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static NeuralNetwork.NormalizationMethod fromValue(String v) {
            for (NeuralNetwork.NormalizationMethod c: NeuralNetwork.NormalizationMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
