
package org.dmg.pmml.regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}NumericPredictor" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}CategoricalPredictor" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}PredictorTerm" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="intercept" use="required" type="{http://www.dmg.org/PMML-4_3}REAL-NUMBER" />
 *       &lt;attribute name="targetCategory" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "numericPredictors",
    "categoricalPredictors",
    "predictorTerms"
})
@XmlRootElement(name = "RegressionTable", namespace = "http://www.dmg.org/PMML-4_3")
public class RegressionTable
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<RegressionTable>
{

    @XmlAttribute(name = "intercept", required = true)
    private double intercept;
    @XmlAttribute(name = "targetCategory")
    private String targetCategory;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "NumericPredictor", namespace = "http://www.dmg.org/PMML-4_3")
    private List<NumericPredictor> numericPredictors;
    @XmlElement(name = "CategoricalPredictor", namespace = "http://www.dmg.org/PMML-4_3")
    private List<CategoricalPredictor> categoricalPredictors;
    @XmlElement(name = "PredictorTerm", namespace = "http://www.dmg.org/PMML-4_3")
    private List<PredictorTerm> predictorTerms;
    private final static long serialVersionUID = 67305478L;

    public RegressionTable() {
    }

    public RegressionTable(
        @org.jpmml.model.Property("intercept")
        double intercept) {
        this.intercept = intercept;
    }

    /**
     * Gets the value of the intercept property.
     * 
     */
    public double getIntercept() {
        return intercept;
    }

    /**
     * Sets the value of the intercept property.
     * 
     */
    public RegressionTable setIntercept(
        @org.jpmml.model.Property("intercept")
        double intercept) {
        this.intercept = intercept;
        return this;
    }

    /**
     * Gets the value of the targetCategory property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTargetCategory() {
        return targetCategory;
    }

    /**
     * Sets the value of the targetCategory property.
     * 
     * @param targetCategory
     *     allowed object is
     *     {@link String }
     *     
     */
    public RegressionTable setTargetCategory(
        @org.jpmml.model.Property("targetCategory")
        String targetCategory) {
        this.targetCategory = targetCategory;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the numericPredictors property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the numericPredictors property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNumericPredictors().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NumericPredictor }
     * 
     * 
     */
    public List<NumericPredictor> getNumericPredictors() {
        if (numericPredictors == null) {
            numericPredictors = new ArrayList<NumericPredictor>();
        }
        return this.numericPredictors;
    }

    /**
     * Gets the value of the categoricalPredictors property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the categoricalPredictors property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCategoricalPredictors().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CategoricalPredictor }
     * 
     * 
     */
    public List<CategoricalPredictor> getCategoricalPredictors() {
        if (categoricalPredictors == null) {
            categoricalPredictors = new ArrayList<CategoricalPredictor>();
        }
        return this.categoricalPredictors;
    }

    /**
     * Gets the value of the predictorTerms property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the predictorTerms property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPredictorTerms().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PredictorTerm }
     * 
     * 
     */
    public List<PredictorTerm> getPredictorTerms() {
        if (predictorTerms == null) {
            predictorTerms = new ArrayList<PredictorTerm>();
        }
        return this.predictorTerms;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public RegressionTable addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasNumericPredictors() {
        return ((this.numericPredictors!= null)&&(this.numericPredictors.size()> 0));
    }

    public RegressionTable addNumericPredictors(NumericPredictor... numericPredictors) {
        getNumericPredictors().addAll(Arrays.asList(numericPredictors));
        return this;
    }

    public boolean hasCategoricalPredictors() {
        return ((this.categoricalPredictors!= null)&&(this.categoricalPredictors.size()> 0));
    }

    public RegressionTable addCategoricalPredictors(CategoricalPredictor... categoricalPredictors) {
        getCategoricalPredictors().addAll(Arrays.asList(categoricalPredictors));
        return this;
    }

    public boolean hasPredictorTerms() {
        return ((this.predictorTerms!= null)&&(this.predictorTerms.size()> 0));
    }

    public RegressionTable addPredictorTerms(PredictorTerm... predictorTerms) {
        getPredictorTerms().addAll(Arrays.asList(predictorTerms));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasNumericPredictors()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getNumericPredictors());
            }
            if ((status == VisitorAction.CONTINUE)&&hasCategoricalPredictors()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getCategoricalPredictors());
            }
            if ((status == VisitorAction.CONTINUE)&&hasPredictorTerms()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getPredictorTerms());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
