
package org.dmg.pmml;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;

@XmlType(name = "COMPARE-FUNCTION", namespace = "http://www.dmg.org/PMML-4_3")
@XmlEnum
public enum CompareFunction {

    @XmlEnumValue("absDiff")
    ABS_DIFF("absDiff"),
    @XmlEnumValue("gaussSim")
    GAUSS_SIM("gaussSim"),
    @XmlEnumValue("delta")
    DELTA("delta"),
    @XmlEnumValue("equal")
    EQUAL("equal"),
    @XmlEnumValue("table")
    TABLE("table");
    private final String value;

    CompareFunction(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static CompareFunction fromValue(String v) {
        for (CompareFunction c: CompareFunction.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
