
package org.dmg.pmml;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.model.annotations.Added;

@XmlType(name = "INVALID-VALUE-TREATMENT-METHOD", namespace = "http://www.dmg.org/PMML-4_3")
@XmlEnum
@Added((org.dmg.pmml.Version.PMML_3_1))
public enum InvalidValueTreatmentMethod {

    @XmlEnumValue("returnInvalid")
    RETURN_INVALID("returnInvalid"),
    @XmlEnumValue("asIs")
    AS_IS("asIs"),
    @XmlEnumValue("asMissing")
    AS_MISSING("asMissing");
    private final String value;

    InvalidValueTreatmentMethod(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static InvalidValueTreatmentMethod fromValue(String v) {
        for (InvalidValueTreatmentMethod c: InvalidValueTreatmentMethod.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
