
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Optional;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "fieldColumnPairs",
    "tableLocator",
    "inlineTable"
})
@XmlRootElement(name = "MapValues", namespace = "http://www.dmg.org/PMML-4_3")
public class MapValues
    extends Expression
    implements HasDataType<MapValues> , HasDefaultValue<MapValues> , HasExtensions<MapValues> , HasMapMissingTo<MapValues, String> , HasTable<MapValues>
{

    @XmlAttribute(name = "mapMissingTo")
    private String mapMissingTo;
    @XmlAttribute(name = "defaultValue")
    private String defaultValue;
    @XmlAttribute(name = "outputColumn", required = true)
    private String outputColumn;
    @XmlAttribute(name = "dataType")
    @Added((org.dmg.pmml.Version.PMML_3_1))
    private DataType dataType;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "FieldColumnPair", namespace = "http://www.dmg.org/PMML-4_3")
    @Optional((org.dmg.pmml.Version.PMML_4_2))
    private List<FieldColumnPair> fieldColumnPairs;
    @XmlElement(name = "TableLocator", namespace = "http://www.dmg.org/PMML-4_3")
    private TableLocator tableLocator;
    @XmlElement(name = "InlineTable", namespace = "http://www.dmg.org/PMML-4_3")
    private InlineTable inlineTable;
    private final static long serialVersionUID = 67305481L;

    public MapValues() {
    }

    public MapValues(
        @org.jpmml.model.annotations.Property("outputColumn")
        String outputColumn) {
        this.outputColumn = outputColumn;
    }

    public String getMapMissingTo() {
        return mapMissingTo;
    }

    public MapValues setMapMissingTo(
        @org.jpmml.model.annotations.Property("mapMissingTo")
        String mapMissingTo) {
        this.mapMissingTo = mapMissingTo;
        return this;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public MapValues setDefaultValue(
        @org.jpmml.model.annotations.Property("defaultValue")
        String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public String getOutputColumn() {
        return outputColumn;
    }

    public MapValues setOutputColumn(
        @org.jpmml.model.annotations.Property("outputColumn")
        String outputColumn) {
        this.outputColumn = outputColumn;
        return this;
    }

    public DataType getDataType() {
        return dataType;
    }

    public MapValues setDataType(
        @org.jpmml.model.annotations.Property("dataType")
        DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<FieldColumnPair> getFieldColumnPairs() {
        if (fieldColumnPairs == null) {
            fieldColumnPairs = new ArrayList<FieldColumnPair>();
        }
        return this.fieldColumnPairs;
    }

    public TableLocator getTableLocator() {
        return tableLocator;
    }

    public MapValues setTableLocator(
        @org.jpmml.model.annotations.Property("tableLocator")
        TableLocator tableLocator) {
        this.tableLocator = tableLocator;
        return this;
    }

    public InlineTable getInlineTable() {
        return inlineTable;
    }

    public MapValues setInlineTable(
        @org.jpmml.model.annotations.Property("inlineTable")
        InlineTable inlineTable) {
        this.inlineTable = inlineTable;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public MapValues addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasFieldColumnPairs() {
        return ((this.fieldColumnPairs!= null)&&(this.fieldColumnPairs.size()> 0));
    }

    public MapValues addFieldColumnPairs(FieldColumnPair... fieldColumnPairs) {
        getFieldColumnPairs().addAll(Arrays.asList(fieldColumnPairs));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasFieldColumnPairs()) {
                status = PMMLObject.traverse(visitor, getFieldColumnPairs());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getTableLocator(), getInlineTable());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
