
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningFields"
})
@XmlRootElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_3")
public class MiningSchema
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<MiningSchema>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "MiningField", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<MiningField> miningFields;
    private final static long serialVersionUID = 67305481L;

    public MiningSchema() {
    }

    public MiningSchema(
        @Property("miningFields")
        List<MiningField> miningFields) {
        this.miningFields = miningFields;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<MiningField> getMiningFields() {
        if (miningFields == null) {
            miningFields = new ArrayList<MiningField>();
        }
        return this.miningFields;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public MiningSchema addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasMiningFields() {
        return ((this.miningFields!= null)&&(this.miningFields.size()> 0));
    }

    public MiningSchema addMiningFields(MiningField... miningFields) {
        getMiningFields().addAll(Arrays.asList(miningFields));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasMiningFields()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getMiningFields());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
