
package org.dmg.pmml.baseline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.DiscreteDistribution;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "COUNT-TABLE-TYPE", namespace = "http://www.dmg.org/PMML-4_3", propOrder = {
    "extensions",
    "fieldValues",
    "fieldValueCounts"
})
@Added((org.dmg.pmml.Version.PMML_4_1))
public class CountTable
    extends DiscreteDistribution
    implements HasExtensions<CountTable>
{

    @XmlAttribute(name = "sample")
    private Double sample;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "FieldValue", namespace = "http://www.dmg.org/PMML-4_3")
    private List<FieldValue> fieldValues;
    @XmlElement(name = "FieldValueCount", namespace = "http://www.dmg.org/PMML-4_3")
    private List<FieldValueCount> fieldValueCounts;
    private final static long serialVersionUID = 67305481L;

    public Double getSample() {
        return sample;
    }

    public CountTable setSample(
        @Property("sample")
        Double sample) {
        this.sample = sample;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<FieldValue> getFieldValues() {
        if (fieldValues == null) {
            fieldValues = new ArrayList<FieldValue>();
        }
        return this.fieldValues;
    }

    public List<FieldValueCount> getFieldValueCounts() {
        if (fieldValueCounts == null) {
            fieldValueCounts = new ArrayList<FieldValueCount>();
        }
        return this.fieldValueCounts;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public CountTable addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasFieldValues() {
        return ((this.fieldValues!= null)&&(this.fieldValues.size()> 0));
    }

    public CountTable addFieldValues(FieldValue... fieldValues) {
        getFieldValues().addAll(Arrays.asList(fieldValues));
        return this;
    }

    public boolean hasFieldValueCounts() {
        return ((this.fieldValueCounts!= null)&&(this.fieldValueCounts.size()> 0));
    }

    public CountTable addFieldValueCounts(FieldValueCount... fieldValueCounts) {
        getFieldValueCounts().addAll(Arrays.asList(fieldValueCounts));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasFieldValues()) {
                status = PMMLObject.traverse(visitor, getFieldValues());
            }
            if ((status == VisitorAction.CONTINUE)&&hasFieldValueCounts()) {
                status = PMMLObject.traverse(visitor, getFieldValueCounts());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
