
package org.dmg.pmml.gaussian_process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "lambdas"
})
@XmlRootElement(name = "AbsoluteExponentialKernel", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_3))
public class AbsoluteExponentialKernel
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<AbsoluteExponentialKernel>
{

    @XmlAttribute(name = "description")
    private String description;
    @XmlAttribute(name = "gamma")
    private Double gamma;
    @XmlAttribute(name = "noiseVariance")
    private Double noiseVariance;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "Lambda", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Lambda> lambdas;
    private final static Double DEFAULT_GAMMA = 1.0D;
    private final static Double DEFAULT_NOISE_VARIANCE = 1.0D;
    private final static long serialVersionUID = 67305481L;

    public String getDescription() {
        return description;
    }

    public AbsoluteExponentialKernel setDescription(
        @Property("description")
        String description) {
        this.description = description;
        return this;
    }

    public Double getGamma() {
        if (gamma == null) {
            return DEFAULT_GAMMA;
        } else {
            return gamma;
        }
    }

    public AbsoluteExponentialKernel setGamma(
        @Property("gamma")
        Double gamma) {
        this.gamma = gamma;
        return this;
    }

    public Double getNoiseVariance() {
        if (noiseVariance == null) {
            return DEFAULT_NOISE_VARIANCE;
        } else {
            return noiseVariance;
        }
    }

    public AbsoluteExponentialKernel setNoiseVariance(
        @Property("noiseVariance")
        Double noiseVariance) {
        this.noiseVariance = noiseVariance;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<Lambda> getLambdas() {
        if (lambdas == null) {
            lambdas = new ArrayList<Lambda>();
        }
        return this.lambdas;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public AbsoluteExponentialKernel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasLambdas() {
        return ((this.lambdas!= null)&&(this.lambdas.size()> 0));
    }

    public AbsoluteExponentialKernel addLambdas(Lambda... lambdas) {
        getLambdas().addAll(Arrays.asList(lambdas));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasLambdas()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getLambdas());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
