
package org.dmg.pmml.general_regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Indexable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "Parameter", namespace = "http://www.dmg.org/PMML-4_3")
public class Parameter
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Parameter> , Indexable<String>
{

    @XmlAttribute(name = "name", required = true)
    private String name;
    @XmlAttribute(name = "label")
    private String label;
    @XmlAttribute(name = "referencePoint")
    @Added((org.dmg.pmml.Version.PMML_4_0))
    private Double referencePoint;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    private final static Double DEFAULT_REFERENCE_POINT = 0.0D;
    private final static long serialVersionUID = 67305481L;

    public Parameter() {
    }

    public Parameter(
        @org.jpmml.model.annotations.Property("name")
        String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public Parameter setName(
        @org.jpmml.model.annotations.Property("name")
        String name) {
        this.name = name;
        return this;
    }

    public String getLabel() {
        return label;
    }

    public Parameter setLabel(
        @org.jpmml.model.annotations.Property("label")
        String label) {
        this.label = label;
        return this;
    }

    public Double getReferencePoint() {
        if (referencePoint == null) {
            return DEFAULT_REFERENCE_POINT;
        } else {
            return referencePoint;
        }
    }

    public Parameter setReferencePoint(
        @org.jpmml.model.annotations.Property("referencePoint")
        Double referencePoint) {
        this.referencePoint = referencePoint;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public String getKey() {
        return getName();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Parameter addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
