
package org.dmg.pmml.nearest_neighbor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasTable;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.TableLocator;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "instanceFields",
    "tableLocator",
    "inlineTable"
})
@XmlRootElement(name = "TrainingInstances", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_1))
public class TrainingInstances
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<TrainingInstances> , HasTable<TrainingInstances>
{

    @XmlAttribute(name = "isTransformed")
    private Boolean transformed;
    @XmlAttribute(name = "recordCount")
    private Integer recordCount;
    @XmlAttribute(name = "fieldCount")
    private Integer fieldCount;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "InstanceFields", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private InstanceFields instanceFields;
    @XmlElement(name = "TableLocator", namespace = "http://www.dmg.org/PMML-4_3")
    private TableLocator tableLocator;
    @XmlElement(name = "InlineTable", namespace = "http://www.dmg.org/PMML-4_3")
    private InlineTable inlineTable;
    private final static Boolean DEFAULT_TRANSFORMED = false;
    private final static long serialVersionUID = 67305481L;

    public TrainingInstances() {
    }

    public TrainingInstances(
        @org.jpmml.model.annotations.Property("instanceFields")
        InstanceFields instanceFields) {
        this.instanceFields = instanceFields;
    }

    public boolean isTransformed() {
        if (transformed == null) {
            return DEFAULT_TRANSFORMED;
        } else {
            return transformed;
        }
    }

    public TrainingInstances setTransformed(
        @org.jpmml.model.annotations.Property("transformed")
        Boolean transformed) {
        this.transformed = transformed;
        return this;
    }

    public Integer getRecordCount() {
        return recordCount;
    }

    public TrainingInstances setRecordCount(
        @org.jpmml.model.annotations.Property("recordCount")
        Integer recordCount) {
        this.recordCount = recordCount;
        return this;
    }

    public Integer getFieldCount() {
        return fieldCount;
    }

    public TrainingInstances setFieldCount(
        @org.jpmml.model.annotations.Property("fieldCount")
        Integer fieldCount) {
        this.fieldCount = fieldCount;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public InstanceFields getInstanceFields() {
        return instanceFields;
    }

    public TrainingInstances setInstanceFields(
        @org.jpmml.model.annotations.Property("instanceFields")
        InstanceFields instanceFields) {
        this.instanceFields = instanceFields;
        return this;
    }

    public TableLocator getTableLocator() {
        return tableLocator;
    }

    public TrainingInstances setTableLocator(
        @org.jpmml.model.annotations.Property("tableLocator")
        TableLocator tableLocator) {
        this.tableLocator = tableLocator;
        return this;
    }

    public InlineTable getInlineTable() {
        return inlineTable;
    }

    public TrainingInstances setInlineTable(
        @org.jpmml.model.annotations.Property("inlineTable")
        InlineTable inlineTable) {
        this.inlineTable = inlineTable;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public TrainingInstances addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getInstanceFields(), getTableLocator(), getInlineTable());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
