/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.nearest_neighbor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.CompareFunction;
import org.dmg.pmml.ComparisonField;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions"})
@XmlRootElement(name="KNNInput", namespace="http://www.dmg.org/PMML-4_3")
@Added(value=Version.PMML_4_1)
public class KNNInput
extends ComparisonField<KNNInput>
implements HasExtensions<KNNInput> {
    @XmlAttribute(name="field", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    private FieldName field;
    @XmlAttribute(name="fieldWeight")
    private Double fieldWeight;
    @XmlAttribute(name="compareFunction")
    private CompareFunction compareFunction;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    private static final Double DEFAULT_FIELD_WEIGHT = 1.0;
    private static final long serialVersionUID = 67305481L;

    public KNNInput() {
    }

    public KNNInput(@Property(value="field") FieldName field) {
        this.field = field;
    }

    @Override
    public FieldName getField() {
        return this.field;
    }

    @Override
    public KNNInput setField(@Property(value="field") FieldName field) {
        this.field = field;
        return this;
    }

    @Override
    public Double getFieldWeight() {
        if (this.fieldWeight == null) {
            return DEFAULT_FIELD_WEIGHT;
        }
        return this.fieldWeight;
    }

    @Override
    public KNNInput setFieldWeight(@Property(value="fieldWeight") Double fieldWeight) {
        this.fieldWeight = fieldWeight;
        return this;
    }

    @Override
    public CompareFunction getCompareFunction() {
        return this.compareFunction;
    }

    @Override
    public KNNInput setCompareFunction(@Property(value="compareFunction") CompareFunction compareFunction) {
        this.compareFunction = compareFunction;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public KNNInput addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

