/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.time_series.Level;
import org.dmg.pmml.time_series.SeasonalityExpoSmooth;
import org.dmg.pmml.time_series.TimeSeriesAlgorithm;
import org.dmg.pmml.time_series.TimeValue;
import org.dmg.pmml.time_series.TrendExpoSmooth;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"level", "trendExpoSmooth", "seasonalityExpoSmooth", "timeValues"})
@XmlRootElement(name="ExponentialSmoothing", namespace="http://www.dmg.org/PMML-4_3")
@Added(value=Version.PMML_4_0)
public class ExponentialSmoothing
extends TimeSeriesAlgorithm {
    @XmlAttribute(name="RMSE")
    private Double rmse;
    @XmlAttribute(name="transformation")
    private Transformation transformation;
    @XmlElement(name="Level", namespace="http://www.dmg.org/PMML-4_3", required=true)
    private Level level;
    @XmlElement(name="Trend_ExpoSmooth", namespace="http://www.dmg.org/PMML-4_3")
    private TrendExpoSmooth trendExpoSmooth;
    @XmlElement(name="Seasonality_ExpoSmooth", namespace="http://www.dmg.org/PMML-4_3")
    private SeasonalityExpoSmooth seasonalityExpoSmooth;
    @XmlElement(name="TimeValue", namespace="http://www.dmg.org/PMML-4_3")
    private List<TimeValue> timeValues;
    private static final long serialVersionUID = 67305481L;

    public ExponentialSmoothing() {
    }

    public ExponentialSmoothing(@Property(value="level") Level level) {
        this.level = level;
    }

    public Double getRMSE() {
        return this.rmse;
    }

    public ExponentialSmoothing setRMSE(@Property(value="rmse") Double rmse) {
        this.rmse = rmse;
        return this;
    }

    public Transformation getTransformation() {
        if (this.transformation == null) {
            return Transformation.NONE;
        }
        return this.transformation;
    }

    public ExponentialSmoothing setTransformation(@Property(value="transformation") Transformation transformation) {
        this.transformation = transformation;
        return this;
    }

    public Level getLevel() {
        return this.level;
    }

    public ExponentialSmoothing setLevel(@Property(value="level") Level level) {
        this.level = level;
        return this;
    }

    public TrendExpoSmooth getTrendExpoSmooth() {
        return this.trendExpoSmooth;
    }

    public ExponentialSmoothing setTrendExpoSmooth(@Property(value="trendExpoSmooth") TrendExpoSmooth trendExpoSmooth) {
        this.trendExpoSmooth = trendExpoSmooth;
        return this;
    }

    public SeasonalityExpoSmooth getSeasonalityExpoSmooth() {
        return this.seasonalityExpoSmooth;
    }

    public ExponentialSmoothing setSeasonalityExpoSmooth(@Property(value="seasonalityExpoSmooth") SeasonalityExpoSmooth seasonalityExpoSmooth) {
        this.seasonalityExpoSmooth = seasonalityExpoSmooth;
        return this;
    }

    public List<TimeValue> getTimeValues() {
        if (this.timeValues == null) {
            this.timeValues = new ArrayList<TimeValue>();
        }
        return this.timeValues;
    }

    public boolean hasTimeValues() {
        return this.timeValues != null && this.timeValues.size() > 0;
    }

    public ExponentialSmoothing addTimeValues(TimeValue ... timeValues) {
        this.getTimeValues().addAll(Arrays.asList(timeValues));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getLevel(), this.getTrendExpoSmooth(), this.getSeasonalityExpoSmooth());
            }
            if (status == VisitorAction.CONTINUE && this.hasTimeValues()) {
                status = PMMLObject.traverse(visitor, this.getTimeValues());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Transformation {
        NONE("none"),
        LOGARITHMIC("logarithmic"),
        SQUAREROOT("squareroot");

        private final String value;

        private Transformation(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static Transformation fromValue(String v) {
            for (Transformation c : Transformation.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

