
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "MultivariateStat", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_1))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "name",
    "category",
    "exponent",
    "intercept",
    "importance",
    "stdError",
    "tValue",
    "chiSquareValue",
    "fStatistic",
    "df",
    "pValueAlpha",
    "pValueInitial",
    "pValueFinal",
    "confidenceLevel",
    "confidenceLowerBound",
    "confidenceUpperBound",
    "extensions"
})
public class MultivariateStat
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<MultivariateStat>
{

    @XmlAttribute(name = "name")
    @JsonProperty("name")
    private String name;
    @XmlAttribute(name = "category")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("category")
    private Object category;
    @XmlAttribute(name = "exponent")
    @JsonProperty("exponent")
    private Integer exponent;
    @XmlAttribute(name = "isIntercept")
    @JsonProperty("isIntercept")
    private Boolean intercept;
    @XmlAttribute(name = "importance")
    @JsonProperty("importance")
    private Double importance;
    @XmlAttribute(name = "stdError")
    @JsonProperty("stdError")
    private Double stdError;
    @XmlAttribute(name = "tValue")
    @JsonProperty("tValue")
    private Double tValue;
    @XmlAttribute(name = "chiSquareValue")
    @JsonProperty("chiSquareValue")
    private Double chiSquareValue;
    @XmlAttribute(name = "fStatistic")
    @JsonProperty("fStatistic")
    private Double fStatistic;
    @XmlAttribute(name = "dF")
    @JsonProperty("dF")
    private Double df;
    @XmlAttribute(name = "pValueAlpha")
    @JsonProperty("pValueAlpha")
    private Double pValueAlpha;
    @XmlAttribute(name = "pValueInitial")
    @JsonProperty("pValueInitial")
    private Double pValueInitial;
    @XmlAttribute(name = "pValueFinal")
    @JsonProperty("pValueFinal")
    private Double pValueFinal;
    @XmlAttribute(name = "confidenceLevel")
    @JsonProperty("confidenceLevel")
    private Double confidenceLevel;
    @XmlAttribute(name = "confidenceLowerBound")
    @JsonProperty("confidenceLowerBound")
    private Double confidenceLowerBound;
    @XmlAttribute(name = "confidenceUpperBound")
    @JsonProperty("confidenceUpperBound")
    private Double confidenceUpperBound;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static Integer DEFAULT_EXPONENT = 1;
    private final static Boolean DEFAULT_INTERCEPT = false;
    private final static Double DEFAULT_CONFIDENCE_LEVEL = 0.95D;
    private final static long serialVersionUID = 67305487L;

    public String getName() {
        return name;
    }

    public MultivariateStat setName(
        @Property("name")
        String name) {
        this.name = name;
        return this;
    }

    public Object getCategory() {
        return category;
    }

    public MultivariateStat setCategory(
        @Property("category")
        Object category) {
        this.category = category;
        return this;
    }

    public Integer getExponent() {
        if (exponent == null) {
            return DEFAULT_EXPONENT;
        } else {
            return exponent;
        }
    }

    public MultivariateStat setExponent(
        @Property("exponent")
        Integer exponent) {
        this.exponent = exponent;
        return this;
    }

    public boolean isIntercept() {
        if (intercept == null) {
            return DEFAULT_INTERCEPT;
        } else {
            return intercept;
        }
    }

    public MultivariateStat setIntercept(
        @Property("intercept")
        Boolean intercept) {
        this.intercept = intercept;
        return this;
    }

    public Double getImportance() {
        return importance;
    }

    public MultivariateStat setImportance(
        @Property("importance")
        Double importance) {
        this.importance = importance;
        return this;
    }

    public Double getStdError() {
        return stdError;
    }

    public MultivariateStat setStdError(
        @Property("stdError")
        Double stdError) {
        this.stdError = stdError;
        return this;
    }

    public Double getTValue() {
        return tValue;
    }

    public MultivariateStat setTValue(
        @Property("tValue")
        Double tValue) {
        this.tValue = tValue;
        return this;
    }

    public Double getChiSquareValue() {
        return chiSquareValue;
    }

    public MultivariateStat setChiSquareValue(
        @Property("chiSquareValue")
        Double chiSquareValue) {
        this.chiSquareValue = chiSquareValue;
        return this;
    }

    public Double getFStatistic() {
        return fStatistic;
    }

    public MultivariateStat setFStatistic(
        @Property("fStatistic")
        Double fStatistic) {
        this.fStatistic = fStatistic;
        return this;
    }

    public Double getDF() {
        return df;
    }

    public MultivariateStat setDF(
        @Property("df")
        Double df) {
        this.df = df;
        return this;
    }

    public Double getPValueAlpha() {
        return pValueAlpha;
    }

    public MultivariateStat setPValueAlpha(
        @Property("pValueAlpha")
        Double pValueAlpha) {
        this.pValueAlpha = pValueAlpha;
        return this;
    }

    public Double getPValueInitial() {
        return pValueInitial;
    }

    public MultivariateStat setPValueInitial(
        @Property("pValueInitial")
        Double pValueInitial) {
        this.pValueInitial = pValueInitial;
        return this;
    }

    public Double getPValueFinal() {
        return pValueFinal;
    }

    public MultivariateStat setPValueFinal(
        @Property("pValueFinal")
        Double pValueFinal) {
        this.pValueFinal = pValueFinal;
        return this;
    }

    public Double getConfidenceLevel() {
        if (confidenceLevel == null) {
            return DEFAULT_CONFIDENCE_LEVEL;
        } else {
            return confidenceLevel;
        }
    }

    public MultivariateStat setConfidenceLevel(
        @Property("confidenceLevel")
        Double confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
        return this;
    }

    public Double getConfidenceLowerBound() {
        return confidenceLowerBound;
    }

    public MultivariateStat setConfidenceLowerBound(
        @Property("confidenceLowerBound")
        Double confidenceLowerBound) {
        this.confidenceLowerBound = confidenceLowerBound;
        return this;
    }

    public Double getConfidenceUpperBound() {
        return confidenceUpperBound;
    }

    public MultivariateStat setConfidenceUpperBound(
        @Property("confidenceUpperBound")
        Double confidenceUpperBound) {
        this.confidenceUpperBound = confidenceUpperBound;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public MultivariateStat addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
