
package org.dmg.pmml.sequence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.Entity;
import org.dmg.pmml.Extension;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "content"
})
@XmlRootElement(name = "SequenceRule", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "id",
    "numberOfSets",
    "occurrence",
    "support",
    "confidence",
    "lift",
    "content"
})
public class SequenceRule
    extends Entity<String>
{

    @XmlAttribute(name = "id", required = true)
    @JsonProperty("id")
    private String id;
    @XmlAttribute(name = "numberOfSets", required = true)
    @JsonProperty("numberOfSets")
    private int numberOfSets;
    @XmlAttribute(name = "occurrence", required = true)
    @JsonProperty("occurrence")
    private int occurrence;
    @XmlAttribute(name = "support", required = true)
    @JsonProperty("support")
    private double support;
    @XmlAttribute(name = "confidence", required = true)
    @JsonProperty("confidence")
    private double confidence;
    @XmlAttribute(name = "lift")
    @Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("lift")
    private Double lift;
    @XmlElementRefs({
        @XmlElementRef(name = "Delimiter", namespace = "http://www.dmg.org/PMML-4_3", type = Delimiter.class, required = false),
        @XmlElementRef(name = "Time", namespace = "http://www.dmg.org/PMML-4_3", type = Time.class, required = false),
        @XmlElementRef(name = "AntecedentSequence", namespace = "http://www.dmg.org/PMML-4_3", type = AntecedentSequence.class, required = false),
        @XmlElementRef(name = "ConsequentSequence", namespace = "http://www.dmg.org/PMML-4_3", type = ConsequentSequence.class, required = false),
        @XmlElementRef(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3", type = Extension.class, required = false)
    })
    @XmlAnyElement(lax = true)
    @JsonProperty("content")
    private List<Object> content;
    private final static long serialVersionUID = 67305487L;

    public SequenceRule() {
    }

    public SequenceRule(
        @org.jpmml.model.annotations.Property("id")
        String id,
        @org.jpmml.model.annotations.Property("numberOfSets")
        int numberOfSets,
        @org.jpmml.model.annotations.Property("occurrence")
        int occurrence,
        @org.jpmml.model.annotations.Property("support")
        double support,
        @org.jpmml.model.annotations.Property("confidence")
        double confidence) {
        this.id = id;
        this.numberOfSets = numberOfSets;
        this.occurrence = occurrence;
        this.support = support;
        this.confidence = confidence;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public SequenceRule setId(
        @org.jpmml.model.annotations.Property("id")
        String id) {
        this.id = id;
        return this;
    }

    public int getNumberOfSets() {
        return numberOfSets;
    }

    public SequenceRule setNumberOfSets(
        @org.jpmml.model.annotations.Property("numberOfSets")
        int numberOfSets) {
        this.numberOfSets = numberOfSets;
        return this;
    }

    public int getOccurrence() {
        return occurrence;
    }

    public SequenceRule setOccurrence(
        @org.jpmml.model.annotations.Property("occurrence")
        int occurrence) {
        this.occurrence = occurrence;
        return this;
    }

    public double getSupport() {
        return support;
    }

    public SequenceRule setSupport(
        @org.jpmml.model.annotations.Property("support")
        double support) {
        this.support = support;
        return this;
    }

    public double getConfidence() {
        return confidence;
    }

    public SequenceRule setConfidence(
        @org.jpmml.model.annotations.Property("confidence")
        double confidence) {
        this.confidence = confidence;
        return this;
    }

    public Double getLift() {
        return lift;
    }

    public SequenceRule setLift(
        @org.jpmml.model.annotations.Property("lift")
        Double lift) {
        this.lift = lift;
        return this;
    }

    public boolean hasContent() {
        return ((this.content!= null)&&(this.content.size()> 0));
    }

    public List<Object> getContent() {
        if (content == null) {
            content = new ArrayList<Object>();
        }
        return this.content;
    }

    public SequenceRule addContent(Object... content) {
        getContent().addAll(Arrays.asList(content));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasContent()) {
                status = PMMLObject.traverseMixed(visitor, getContent());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
