
package org.dmg.pmml;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.eclipse.persistence.oxm.annotations.XmlValueExtension;
import org.jpmml.model.annotations.ValueConstructor;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "value"
})
@XmlRootElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "n",
    "type",
    "value"
})
public class Array
    extends PMMLObject
{

    @XmlAttribute(name = "n")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("n")
    private Integer n;
    @XmlAttribute(name = "type", required = true)
    @JsonProperty("type")
    private Array.Type type;
    @XmlValue
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("value")
    @XmlValueExtension
    private Object value;
    private final static long serialVersionUID = 67305489L;

    public Array() {
    }

    @ValueConstructor
    public Array(
        @org.jpmml.model.annotations.Property("type")
        Array.Type type,
        @org.jpmml.model.annotations.Property("value")
        Object value) {
        this.type = type;
        this.value = value;
    }

    public Integer getN() {
        return n;
    }

    public Array setN(
        @org.jpmml.model.annotations.Property("n")
        Integer n) {
        this.n = n;
        return this;
    }

    public Array.Type getType() {
        return type;
    }

    public Array setType(
        @org.jpmml.model.annotations.Property("type")
        Array.Type type) {
        this.type = type;
        return this;
    }

    public Object getValue() {
        return value;
    }

    public Array setValue(
        @org.jpmml.model.annotations.Property("value")
        Object value) {
        this.value = value;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Type
        implements StringValue<Array.Type>
    {

        @XmlEnumValue("int")
        @JsonProperty("int")
        INT("int"),
        @XmlEnumValue("real")
        @JsonProperty("real")
        REAL("real"),
        @XmlEnumValue("string")
        @JsonProperty("string")
        STRING("string");
        private final String value;

        Type(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static Array.Type fromValue(String v) {
            for (Array.Type c: Array.Type.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
