
package org.dmg.pmml.association;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasId;
import org.dmg.pmml.Indexable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.dmg.pmml.adapters.ProbabilityNumberAdapter;
import org.jpmml.model.annotations.ValueConstructor;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "itemRefs"
})
@XmlRootElement(name = "Itemset", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "id",
    "support",
    "numberOfItems",
    "extensions",
    "itemRefs"
})
public class Itemset
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Itemset> , HasId<Itemset, String> , Indexable<String>
{

    @XmlAttribute(name = "id", required = true)
    @JsonProperty("id")
    private String id;
    @XmlAttribute(name = "support")
    @XmlJavaTypeAdapter(ProbabilityNumberAdapter.class)
    @JsonProperty("support")
    private Number support;
    @XmlAttribute(name = "numberOfItems")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("numberOfItems")
    private Integer numberOfItems;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "ItemRef", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("ItemRef")
    private List<ItemRef> itemRefs;
    private final static long serialVersionUID = 67305489L;

    public Itemset() {
    }

    @ValueConstructor
    public Itemset(
        @org.jpmml.model.annotations.Property("id")
        String id) {
        this.id = id;
    }

    @Override
    public String getKey() {
        return getId();
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public Itemset setId(
        @org.jpmml.model.annotations.Property("id")
        String id) {
        this.id = id;
        return this;
    }

    public Number getSupport() {
        return support;
    }

    public Itemset setSupport(
        @org.jpmml.model.annotations.Property("support")
        Number support) {
        this.support = support;
        return this;
    }

    public Integer getNumberOfItems() {
        return numberOfItems;
    }

    public Itemset setNumberOfItems(
        @org.jpmml.model.annotations.Property("numberOfItems")
        Integer numberOfItems) {
        this.numberOfItems = numberOfItems;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Itemset addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasItemRefs() {
        return ((this.itemRefs!= null)&&(this.itemRefs.size()> 0));
    }

    public List<ItemRef> getItemRefs() {
        if (itemRefs == null) {
            itemRefs = new ArrayList<ItemRef>();
        }
        return this.itemRefs;
    }

    public Itemset addItemRefs(ItemRef... itemRefs) {
        getItemRefs().addAll(Arrays.asList(itemRefs));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasItemRefs()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getItemRefs());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
