
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.PositiveIntegerAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Lag", namespace = "http://www.dmg.org/PMML-4_3")
@XmlType(name = "", propOrder = {
    "extensions",
    "blockIndicators"
})
@Added((org.dmg.pmml.Version.PMML_4_3))
@JsonRootName("Lag")
@JsonPropertyOrder({
    "field",
    "n",
    "extensions",
    "blockIndicators"
})
public class Lag
    extends Expression
    implements HasExtensions<Lag> , HasFieldReference<Lag>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    private FieldName field;
    @XmlAttribute(name = "n")
    @XmlJavaTypeAdapter(PositiveIntegerAdapter.class)
    @XmlSchemaType(name = "positiveInteger")
    @JsonProperty("n")
    private Integer n;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "BlockIndicator", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("BlockIndicator")
    private List<BlockIndicator> blockIndicators;
    private final static Integer DEFAULT_N = new PositiveIntegerAdapter().unmarshal("1");
    private final static long serialVersionUID = 67305489L;

    public Lag() {
    }

    @ValueConstructor
    public Lag(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
    }

    @Override
    public FieldName getField() {
        return field;
    }

    @Override
    public Lag setField(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    public Integer getN() {
        if (n == null) {
            return DEFAULT_N;
        } else {
            return n;
        }
    }

    public Lag setN(
        @org.jpmml.model.annotations.Property("n")
        Integer n) {
        this.n = n;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Lag addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasBlockIndicators() {
        return ((this.blockIndicators!= null)&&(this.blockIndicators.size()> 0));
    }

    public List<BlockIndicator> getBlockIndicators() {
        if (blockIndicators == null) {
            blockIndicators = new ArrayList<BlockIndicator>();
        }
        return this.blockIndicators;
    }

    public Lag addBlockIndicators(BlockIndicator... blockIndicators) {
        getBlockIndicators().addAll(Arrays.asList(blockIndicators));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasBlockIndicators()) {
                status = PMMLObject.traverse(visitor, getBlockIndicators());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
