
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "classLabels",
    "matrix"
})
@XmlRootElement(name = "ConfusionMatrix", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_0))
public class ConfusionMatrix
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ConfusionMatrix>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "ClassLabels", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private ClassLabels classLabels;
    @XmlElement(name = "Matrix", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private Matrix matrix;
    private final static long serialVersionUID = 67305482L;

    public ConfusionMatrix() {
    }

    public ConfusionMatrix(
        @org.jpmml.model.annotations.Property("classLabels")
        ClassLabels classLabels,
        @org.jpmml.model.annotations.Property("matrix")
        Matrix matrix) {
        this.classLabels = classLabels;
        this.matrix = matrix;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public ClassLabels getClassLabels() {
        return classLabels;
    }

    public ConfusionMatrix setClassLabels(
        @org.jpmml.model.annotations.Property("classLabels")
        ClassLabels classLabels) {
        this.classLabels = classLabels;
        return this;
    }

    public Matrix getMatrix() {
        return matrix;
    }

    public ConfusionMatrix setMatrix(
        @org.jpmml.model.annotations.Property("matrix")
        Matrix matrix) {
        this.matrix = matrix;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public ConfusionMatrix addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getClassLabels(), getMatrix());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
