
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "partitionFieldStats"
})
@XmlRootElement(name = "Partition", namespace = "http://www.dmg.org/PMML-4_3")
public class Partition
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Partition>
{

    @XmlAttribute(name = "name", required = true)
    private String name;
    @XmlAttribute(name = "size")
    private Double size;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "PartitionFieldStats", namespace = "http://www.dmg.org/PMML-4_3")
    private List<PartitionFieldStats> partitionFieldStats;
    private final static long serialVersionUID = 67305482L;

    public Partition() {
    }

    public Partition(
        @org.jpmml.model.annotations.Property("name")
        String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public Partition setName(
        @org.jpmml.model.annotations.Property("name")
        String name) {
        this.name = name;
        return this;
    }

    public Double getSize() {
        return size;
    }

    public Partition setSize(
        @org.jpmml.model.annotations.Property("size")
        Double size) {
        this.size = size;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<PartitionFieldStats> getPartitionFieldStats() {
        if (partitionFieldStats == null) {
            partitionFieldStats = new ArrayList<PartitionFieldStats>();
        }
        return this.partitionFieldStats;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Partition addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasPartitionFieldStats() {
        return ((this.partitionFieldStats!= null)&&(this.partitionFieldStats.size()> 0));
    }

    public Partition addPartitionFieldStats(PartitionFieldStats... partitionFieldStats) {
        getPartitionFieldStats().addAll(Arrays.asList(partitionFieldStats));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasPartitionFieldStats()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getPartitionFieldStats());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
