
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "counts",
    "numericInfo",
    "arrays"
})
@XmlRootElement(name = "PartitionFieldStats", namespace = "http://www.dmg.org/PMML-4_3")
public class PartitionFieldStats
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<PartitionFieldStats> , HasFieldReference<PartitionFieldStats>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName field;
    @XmlAttribute(name = "weighted")
    @Added((org.dmg.pmml.Version.PMML_4_0))
    private PartitionFieldStats.Weighted weighted;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "Counts", namespace = "http://www.dmg.org/PMML-4_3")
    private Counts counts;
    @XmlElement(name = "NumericInfo", namespace = "http://www.dmg.org/PMML-4_3")
    private NumericInfo numericInfo;
    @XmlElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Array> arrays;
    private final static long serialVersionUID = 67305482L;

    public PartitionFieldStats() {
    }

    public PartitionFieldStats(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
    }

    public FieldName getField() {
        return field;
    }

    public PartitionFieldStats setField(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    public PartitionFieldStats.Weighted getWeighted() {
        if (weighted == null) {
            return PartitionFieldStats.Weighted.ZERO;
        } else {
            return weighted;
        }
    }

    public PartitionFieldStats setWeighted(
        @org.jpmml.model.annotations.Property("weighted")
        PartitionFieldStats.Weighted weighted) {
        this.weighted = weighted;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public Counts getCounts() {
        return counts;
    }

    public PartitionFieldStats setCounts(
        @org.jpmml.model.annotations.Property("counts")
        Counts counts) {
        this.counts = counts;
        return this;
    }

    public NumericInfo getNumericInfo() {
        return numericInfo;
    }

    public PartitionFieldStats setNumericInfo(
        @org.jpmml.model.annotations.Property("numericInfo")
        NumericInfo numericInfo) {
        this.numericInfo = numericInfo;
        return this;
    }

    public List<Array> getArrays() {
        if (arrays == null) {
            arrays = new ArrayList<Array>();
        }
        return this.arrays;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public PartitionFieldStats addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasArrays() {
        return ((this.arrays!= null)&&(this.arrays.size()> 0));
    }

    public PartitionFieldStats addArrays(Array... arrays) {
        getArrays().addAll(Arrays.asList(arrays));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getCounts(), getNumericInfo());
            }
            if ((status == VisitorAction.CONTINUE)&&hasArrays()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getArrays());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Weighted {

        @XmlEnumValue("0")
        ZERO("0"),
        @XmlEnumValue("1")
        ONE("1");
        private final String value;

        Weighted(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static PartitionFieldStats.Weighted fromValue(String v) {
            for (PartitionFieldStats.Weighted c: PartitionFieldStats.Weighted.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
