
package org.dmg.pmml.general_regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "baselineCells"
})
@XmlRootElement(name = "BaselineStratum", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_0))
public class BaselineStratum
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<BaselineStratum>
{

    @XmlAttribute(name = "value", required = true)
    private String value;
    @XmlAttribute(name = "label")
    private String label;
    @XmlAttribute(name = "maxTime", required = true)
    private double maxTime;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "BaselineCell", namespace = "http://www.dmg.org/PMML-4_3")
    private List<BaselineCell> baselineCells;
    private final static long serialVersionUID = 67305482L;

    public BaselineStratum() {
    }

    public BaselineStratum(
        @org.jpmml.model.annotations.Property("value")
        String value,
        @org.jpmml.model.annotations.Property("maxTime")
        double maxTime) {
        this.value = value;
        this.maxTime = maxTime;
    }

    public String getValue() {
        return value;
    }

    public BaselineStratum setValue(
        @org.jpmml.model.annotations.Property("value")
        String value) {
        this.value = value;
        return this;
    }

    public String getLabel() {
        return label;
    }

    public BaselineStratum setLabel(
        @org.jpmml.model.annotations.Property("label")
        String label) {
        this.label = label;
        return this;
    }

    public double getMaxTime() {
        return maxTime;
    }

    public BaselineStratum setMaxTime(
        @org.jpmml.model.annotations.Property("maxTime")
        double maxTime) {
        this.maxTime = maxTime;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<BaselineCell> getBaselineCells() {
        if (baselineCells == null) {
            baselineCells = new ArrayList<BaselineCell>();
        }
        return this.baselineCells;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public BaselineStratum addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasBaselineCells() {
        return ((this.baselineCells!= null)&&(this.baselineCells.size()> 0));
    }

    public BaselineStratum addBaselineCells(BaselineCell... baselineCells) {
        getBaselineCells().addAll(Arrays.asList(baselineCells));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasBaselineCells()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getBaselineCells());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
