
package org.dmg.pmml.neural_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.neural_network.NeuralNetwork.ActivationFunction;
import org.dmg.pmml.neural_network.NeuralNetwork.NormalizationMethod;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "neurons"
})
@XmlRootElement(name = "NeuralLayer", namespace = "http://www.dmg.org/PMML-4_3")
public class NeuralLayer
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<NeuralLayer>
{

    @XmlAttribute(name = "numberOfNeurons")
    private Integer numberOfNeurons;
    @XmlAttribute(name = "activationFunction")
    private ActivationFunction activationFunction;
    @XmlAttribute(name = "threshold")
    private Double threshold;
    @XmlAttribute(name = "width")
    private Double width;
    @XmlAttribute(name = "altitude")
    private Double altitude;
    @XmlAttribute(name = "normalizationMethod")
    private NormalizationMethod normalizationMethod;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "Neuron", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<Neuron> neurons;
    private final static long serialVersionUID = 67305482L;

    public NeuralLayer() {
    }

    public NeuralLayer(
        @org.jpmml.model.annotations.Property("neurons")
        List<Neuron> neurons) {
        this.neurons = neurons;
    }

    public Integer getNumberOfNeurons() {
        return numberOfNeurons;
    }

    public NeuralLayer setNumberOfNeurons(
        @org.jpmml.model.annotations.Property("numberOfNeurons")
        Integer numberOfNeurons) {
        this.numberOfNeurons = numberOfNeurons;
        return this;
    }

    public ActivationFunction getActivationFunction() {
        return activationFunction;
    }

    public NeuralLayer setActivationFunction(
        @org.jpmml.model.annotations.Property("activationFunction")
        ActivationFunction activationFunction) {
        this.activationFunction = activationFunction;
        return this;
    }

    public Double getThreshold() {
        return threshold;
    }

    public NeuralLayer setThreshold(
        @org.jpmml.model.annotations.Property("threshold")
        Double threshold) {
        this.threshold = threshold;
        return this;
    }

    public Double getWidth() {
        return width;
    }

    public NeuralLayer setWidth(
        @org.jpmml.model.annotations.Property("width")
        Double width) {
        this.width = width;
        return this;
    }

    public Double getAltitude() {
        return altitude;
    }

    public NeuralLayer setAltitude(
        @org.jpmml.model.annotations.Property("altitude")
        Double altitude) {
        this.altitude = altitude;
        return this;
    }

    public NormalizationMethod getNormalizationMethod() {
        return normalizationMethod;
    }

    public NeuralLayer setNormalizationMethod(
        @org.jpmml.model.annotations.Property("normalizationMethod")
        NormalizationMethod normalizationMethod) {
        this.normalizationMethod = normalizationMethod;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<Neuron> getNeurons() {
        if (neurons == null) {
            neurons = new ArrayList<Neuron>();
        }
        return this.neurons;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public NeuralLayer addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasNeurons() {
        return ((this.neurons!= null)&&(this.neurons.size()> 0));
    }

    public NeuralLayer addNeurons(Neuron... neurons) {
        getNeurons().addAll(Arrays.asList(neurons));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasNeurons()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getNeurons());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
