
package org.dmg.pmml.regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "NumericPredictor", namespace = "http://www.dmg.org/PMML-4_3")
public class NumericPredictor
    extends Term
    implements HasExtensions<NumericPredictor> , HasFieldReference<NumericPredictor>
{

    @XmlAttribute(name = "name", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private org.dmg.pmml.FieldName field;
    @XmlAttribute(name = "exponent")
    private Integer exponent;
    @XmlAttribute(name = "coefficient", required = true)
    private double coefficient;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    private final static Integer DEFAULT_EXPONENT = 1;
    private final static long serialVersionUID = 67305482L;

    public NumericPredictor() {
    }

    public NumericPredictor(
        @org.jpmml.model.annotations.Property("field")
        org.dmg.pmml.FieldName field,
        @org.jpmml.model.annotations.Property("coefficient")
        double coefficient) {
        this.field = field;
        this.coefficient = coefficient;
    }

    public org.dmg.pmml.FieldName getField() {
        return field;
    }

    public NumericPredictor setField(
        @org.jpmml.model.annotations.Property("field")
        org.dmg.pmml.FieldName field) {
        this.field = field;
        return this;
    }

    public Integer getExponent() {
        if (exponent == null) {
            return DEFAULT_EXPONENT;
        } else {
            return exponent;
        }
    }

    public NumericPredictor setExponent(
        @org.jpmml.model.annotations.Property("exponent")
        Integer exponent) {
        this.exponent = exponent;
        return this;
    }

    public double getCoefficient() {
        return coefficient;
    }

    public NumericPredictor setCoefficient(
        @org.jpmml.model.annotations.Property("coefficient")
        double coefficient) {
        this.coefficient = coefficient;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public org.dmg.pmml.FieldName getName() {
        return getField();
    }

    @Override
    public NumericPredictor setName(org.dmg.pmml.FieldName name) {
        return setField(name);
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public NumericPredictor addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
