
package org.dmg.pmml.rule_set;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "ruleSelectionMethods",
    "scoreDistributions",
    "rules"
})
@XmlRootElement(name = "RuleSet", namespace = "http://www.dmg.org/PMML-4_3")
public class RuleSet
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<RuleSet>
{

    @XmlAttribute(name = "recordCount")
    private Double recordCount;
    @XmlAttribute(name = "nbCorrect")
    private Double nbCorrect;
    @XmlAttribute(name = "defaultScore")
    private String defaultScore;
    @XmlAttribute(name = "defaultConfidence")
    private Double defaultConfidence;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "RuleSelectionMethod", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<RuleSelectionMethod> ruleSelectionMethods;
    @XmlElement(name = "ScoreDistribution", namespace = "http://www.dmg.org/PMML-4_3")
    private List<ScoreDistribution> scoreDistributions;
    @XmlElements({
        @XmlElement(name = "SimpleRule", namespace = "http://www.dmg.org/PMML-4_3", type = SimpleRule.class),
        @XmlElement(name = "CompoundRule", namespace = "http://www.dmg.org/PMML-4_3", type = CompoundRule.class)
    })
    private List<Rule> rules;
    private final static long serialVersionUID = 67305482L;

    public RuleSet() {
    }

    public RuleSet(
        @org.jpmml.model.annotations.Property("ruleSelectionMethods")
        List<RuleSelectionMethod> ruleSelectionMethods) {
        this.ruleSelectionMethods = ruleSelectionMethods;
    }

    public Double getRecordCount() {
        return recordCount;
    }

    public RuleSet setRecordCount(
        @org.jpmml.model.annotations.Property("recordCount")
        Double recordCount) {
        this.recordCount = recordCount;
        return this;
    }

    public Double getNbCorrect() {
        return nbCorrect;
    }

    public RuleSet setNbCorrect(
        @org.jpmml.model.annotations.Property("nbCorrect")
        Double nbCorrect) {
        this.nbCorrect = nbCorrect;
        return this;
    }

    public String getDefaultScore() {
        return defaultScore;
    }

    public RuleSet setDefaultScore(
        @org.jpmml.model.annotations.Property("defaultScore")
        String defaultScore) {
        this.defaultScore = defaultScore;
        return this;
    }

    public Double getDefaultConfidence() {
        return defaultConfidence;
    }

    public RuleSet setDefaultConfidence(
        @org.jpmml.model.annotations.Property("defaultConfidence")
        Double defaultConfidence) {
        this.defaultConfidence = defaultConfidence;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<RuleSelectionMethod> getRuleSelectionMethods() {
        if (ruleSelectionMethods == null) {
            ruleSelectionMethods = new ArrayList<RuleSelectionMethod>();
        }
        return this.ruleSelectionMethods;
    }

    public List<ScoreDistribution> getScoreDistributions() {
        if (scoreDistributions == null) {
            scoreDistributions = new ArrayList<ScoreDistribution>();
        }
        return this.scoreDistributions;
    }

    public List<Rule> getRules() {
        if (rules == null) {
            rules = new ArrayList<Rule>();
        }
        return this.rules;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public RuleSet addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasRuleSelectionMethods() {
        return ((this.ruleSelectionMethods!= null)&&(this.ruleSelectionMethods.size()> 0));
    }

    public RuleSet addRuleSelectionMethods(RuleSelectionMethod... ruleSelectionMethods) {
        getRuleSelectionMethods().addAll(Arrays.asList(ruleSelectionMethods));
        return this;
    }

    public boolean hasScoreDistributions() {
        return ((this.scoreDistributions!= null)&&(this.scoreDistributions.size()> 0));
    }

    public RuleSet addScoreDistributions(ScoreDistribution... scoreDistributions) {
        getScoreDistributions().addAll(Arrays.asList(scoreDistributions));
        return this;
    }

    public boolean hasRules() {
        return ((this.rules!= null)&&(this.rules.size()> 0));
    }

    public RuleSet addRules(Rule... rules) {
        getRules().addAll(Arrays.asList(rules));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasRuleSelectionMethods()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getRuleSelectionMethods());
            }
            if ((status == VisitorAction.CONTINUE)&&hasScoreDistributions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getScoreDistributions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasRules()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getRules());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
