
package org.dmg.pmml.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "TextModelNormalization", namespace = "http://www.dmg.org/PMML-4_3")
public class TextModelNormalization
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<TextModelNormalization>
{

    @XmlAttribute(name = "localTermWeights")
    private TextModelNormalization.LocalTermWeights localTermWeights;
    @XmlAttribute(name = "globalTermWeights")
    private TextModelNormalization.GlobalTermWeights globalTermWeights;
    @XmlAttribute(name = "documentNormalization")
    private TextModelNormalization.DocumentNormalization documentNormalization;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67305482L;

    public TextModelNormalization.LocalTermWeights getLocalTermWeights() {
        if (localTermWeights == null) {
            return TextModelNormalization.LocalTermWeights.TERM_FREQUENCY;
        } else {
            return localTermWeights;
        }
    }

    public TextModelNormalization setLocalTermWeights(
        @Property("localTermWeights")
        TextModelNormalization.LocalTermWeights localTermWeights) {
        this.localTermWeights = localTermWeights;
        return this;
    }

    public TextModelNormalization.GlobalTermWeights getGlobalTermWeights() {
        if (globalTermWeights == null) {
            return TextModelNormalization.GlobalTermWeights.INVERSE_DOCUMENT_FREQUENCY;
        } else {
            return globalTermWeights;
        }
    }

    public TextModelNormalization setGlobalTermWeights(
        @Property("globalTermWeights")
        TextModelNormalization.GlobalTermWeights globalTermWeights) {
        this.globalTermWeights = globalTermWeights;
        return this;
    }

    public TextModelNormalization.DocumentNormalization getDocumentNormalization() {
        if (documentNormalization == null) {
            return TextModelNormalization.DocumentNormalization.NONE;
        } else {
            return documentNormalization;
        }
    }

    public TextModelNormalization setDocumentNormalization(
        @Property("documentNormalization")
        TextModelNormalization.DocumentNormalization documentNormalization) {
        this.documentNormalization = documentNormalization;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public TextModelNormalization addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum DocumentNormalization {

        @XmlEnumValue("none")
        NONE("none"),
        @XmlEnumValue("cosine")
        COSINE("cosine");
        private final String value;

        DocumentNormalization(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static TextModelNormalization.DocumentNormalization fromValue(String v) {
            for (TextModelNormalization.DocumentNormalization c: TextModelNormalization.DocumentNormalization.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum GlobalTermWeights {

        @XmlEnumValue("inverseDocumentFrequency")
        INVERSE_DOCUMENT_FREQUENCY("inverseDocumentFrequency"),
        @XmlEnumValue("none")
        NONE("none"),
        GFIDF("GFIDF"),
        @XmlEnumValue("normal")
        NORMAL("normal"),
        @XmlEnumValue("probabilisticInverse")
        PROBABILISTIC_INVERSE("probabilisticInverse");
        private final String value;

        GlobalTermWeights(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static TextModelNormalization.GlobalTermWeights fromValue(String v) {
            for (TextModelNormalization.GlobalTermWeights c: TextModelNormalization.GlobalTermWeights.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum LocalTermWeights {

        @XmlEnumValue("termFrequency")
        TERM_FREQUENCY("termFrequency"),
        @XmlEnumValue("binary")
        BINARY("binary"),
        @XmlEnumValue("logarithmic")
        LOGARITHMIC("logarithmic"),
        @XmlEnumValue("augmentedNormalizedTermFrequency")
        AUGMENTED_NORMALIZED_TERM_FREQUENCY("augmentedNormalizedTermFrequency");
        private final String value;

        LocalTermWeights(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static TextModelNormalization.LocalTermWeights fromValue(String v) {
            for (TextModelNormalization.LocalTermWeights c: TextModelNormalization.LocalTermWeights.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
