/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum Version {
    PMML_3_0("http://www.dmg.org/PMML-3_0"),
    PMML_3_1("http://www.dmg.org/PMML-3_1"),
    PMML_3_2("http://www.dmg.org/PMML-3_2"),
    PMML_4_0("http://www.dmg.org/PMML-4_0"),
    PMML_4_1("http://www.dmg.org/PMML-4_1"),
    PMML_4_2("http://www.dmg.org/PMML-4_2"),
    PMML_4_3("http://www.dmg.org/PMML-4_3");

    private String namespaceUri = null;
    private static final Pattern PATTERN_XMLNS;

    private Version(String namespaceUri) {
        this.setNamespaceURI(namespaceUri);
    }

    public String getNamespaceURI() {
        return this.namespaceUri;
    }

    private void setNamespaceURI(String namespaceUri) {
        this.namespaceUri = namespaceUri;
    }

    public String getVersion() {
        String namespaceURI = this.getNamespaceURI();
        String version = namespaceURI.substring("http://www.dmg.org/PMML-".length());
        return version.replace('_', '.');
    }

    public static Version getMinimum() {
        Version[] versions = Version.values();
        return versions[0];
    }

    public static Version getMaximum() {
        Version[] versions = Version.values();
        return versions[versions.length - 1];
    }

    public static Version forNamespaceURI(String namespaceURI) {
        Version[] versions;
        for (Version version : versions = Version.values()) {
            if (!version.getNamespaceURI().equals(namespaceURI)) continue;
            return version;
        }
        Matcher matcher = PATTERN_XMLNS.matcher(namespaceURI);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("PMML namespace URI " + namespaceURI + " does not match '" + PATTERN_XMLNS.pattern() + "' regex pattern");
        }
        throw new IllegalArgumentException("PMML namespace URI " + namespaceURI + " is not supported");
    }

    static {
        PATTERN_XMLNS = Pattern.compile("http://www\\.dmg\\.org/PMML\\-\\d_\\d");
    }
}

