
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "measure"
})
@XmlRootElement(name = "ComparisonMeasure", namespace = "http://www.dmg.org/PMML-4_3")
public class ComparisonMeasure
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ComparisonMeasure>
{

    @XmlAttribute(name = "kind", required = true)
    private ComparisonMeasure.Kind kind;
    @XmlAttribute(name = "compareFunction")
    private CompareFunction compareFunction;
    @XmlAttribute(name = "minimum")
    private Double minimum;
    @XmlAttribute(name = "maximum")
    private Double maximum;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "euclidean", namespace = "http://www.dmg.org/PMML-4_3", type = Euclidean.class),
        @XmlElement(name = "squaredEuclidean", namespace = "http://www.dmg.org/PMML-4_3", type = SquaredEuclidean.class),
        @XmlElement(name = "chebychev", namespace = "http://www.dmg.org/PMML-4_3", type = Chebychev.class),
        @XmlElement(name = "cityBlock", namespace = "http://www.dmg.org/PMML-4_3", type = CityBlock.class),
        @XmlElement(name = "minkowski", namespace = "http://www.dmg.org/PMML-4_3", type = Minkowski.class),
        @XmlElement(name = "simpleMatching", namespace = "http://www.dmg.org/PMML-4_3", type = SimpleMatching.class),
        @XmlElement(name = "jaccard", namespace = "http://www.dmg.org/PMML-4_3", type = Jaccard.class),
        @XmlElement(name = "tanimoto", namespace = "http://www.dmg.org/PMML-4_3", type = Tanimoto.class),
        @XmlElement(name = "binarySimilarity", namespace = "http://www.dmg.org/PMML-4_3", type = BinarySimilarity.class)
    })
    private Measure measure;
    private final static long serialVersionUID = 67305483L;

    public ComparisonMeasure() {
    }

    public ComparisonMeasure(
        @org.jpmml.model.annotations.Property("kind")
        ComparisonMeasure.Kind kind) {
        this.kind = kind;
    }

    public ComparisonMeasure.Kind getKind() {
        return kind;
    }

    public ComparisonMeasure setKind(
        @org.jpmml.model.annotations.Property("kind")
        ComparisonMeasure.Kind kind) {
        this.kind = kind;
        return this;
    }

    public CompareFunction getCompareFunction() {
        if (compareFunction == null) {
            return CompareFunction.ABS_DIFF;
        } else {
            return compareFunction;
        }
    }

    public ComparisonMeasure setCompareFunction(
        @org.jpmml.model.annotations.Property("compareFunction")
        CompareFunction compareFunction) {
        this.compareFunction = compareFunction;
        return this;
    }

    public Double getMinimum() {
        return minimum;
    }

    public ComparisonMeasure setMinimum(
        @org.jpmml.model.annotations.Property("minimum")
        Double minimum) {
        this.minimum = minimum;
        return this;
    }

    public Double getMaximum() {
        return maximum;
    }

    public ComparisonMeasure setMaximum(
        @org.jpmml.model.annotations.Property("maximum")
        Double maximum) {
        this.maximum = maximum;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public Measure getMeasure() {
        return measure;
    }

    public ComparisonMeasure setMeasure(
        @org.jpmml.model.annotations.Property("measure")
        Measure measure) {
        this.measure = measure;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public ComparisonMeasure addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Kind {

        @XmlEnumValue("distance")
        DISTANCE("distance"),
        @XmlEnumValue("similarity")
        SIMILARITY("similarity");
        private final String value;

        Kind(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static ComparisonMeasure.Kind fromValue(String v) {
            for (ComparisonMeasure.Kind c: ComparisonMeasure.Kind.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
