
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.annotations.Required;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "intervals",
    "values"
})
@XmlRootElement(name = "DataField", namespace = "http://www.dmg.org/PMML-4_3")
public class DataField
    extends Field<DataField>
    implements HasContinuousDomain<DataField> , HasDiscreteDomain<DataField> , HasDisplayName<DataField> , HasExtensions<DataField>
{

    @XmlAttribute(name = "name", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName name;
    @XmlAttribute(name = "displayName")
    private String displayName;
    @XmlAttribute(name = "optype", required = true)
    private OpType opType;
    @XmlAttribute(name = "dataType", required = true)
    @Required((org.dmg.pmml.Version.PMML_3_1))
    private DataType dataType;
    @XmlAttribute(name = "taxonomy")
    private String taxonomy;
    @XmlAttribute(name = "isCyclic")
    private DataField.Cyclic cyclic;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "Interval", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Interval> intervals;
    @XmlElement(name = "Value", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Value> values;
    private final static long serialVersionUID = 67305483L;

    public DataField() {
    }

    public DataField(
        @org.jpmml.model.annotations.Property("name")
        FieldName name,
        @org.jpmml.model.annotations.Property("opType")
        OpType opType,
        @org.jpmml.model.annotations.Property("dataType")
        DataType dataType) {
        this.name = name;
        this.opType = opType;
        this.dataType = dataType;
    }

    public FieldName getName() {
        return name;
    }

    public DataField setName(
        @org.jpmml.model.annotations.Property("name")
        FieldName name) {
        this.name = name;
        return this;
    }

    public String getDisplayName() {
        return displayName;
    }

    public DataField setDisplayName(
        @org.jpmml.model.annotations.Property("displayName")
        String displayName) {
        this.displayName = displayName;
        return this;
    }

    public OpType getOpType() {
        return opType;
    }

    public DataField setOpType(
        @org.jpmml.model.annotations.Property("opType")
        OpType opType) {
        this.opType = opType;
        return this;
    }

    public DataType getDataType() {
        return dataType;
    }

    public DataField setDataType(
        @org.jpmml.model.annotations.Property("dataType")
        DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public String getTaxonomy() {
        return taxonomy;
    }

    public DataField setTaxonomy(
        @org.jpmml.model.annotations.Property("taxonomy")
        String taxonomy) {
        this.taxonomy = taxonomy;
        return this;
    }

    public DataField.Cyclic getCyclic() {
        if (cyclic == null) {
            return DataField.Cyclic.ZERO;
        } else {
            return cyclic;
        }
    }

    public DataField setCyclic(
        @org.jpmml.model.annotations.Property("cyclic")
        DataField.Cyclic cyclic) {
        this.cyclic = cyclic;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<Interval> getIntervals() {
        if (intervals == null) {
            intervals = new ArrayList<Interval>();
        }
        return this.intervals;
    }

    public List<Value> getValues() {
        if (values == null) {
            values = new ArrayList<Value>();
        }
        return this.values;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public DataField addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasIntervals() {
        return ((this.intervals!= null)&&(this.intervals.size()> 0));
    }

    public DataField addIntervals(Interval... intervals) {
        getIntervals().addAll(Arrays.asList(intervals));
        return this;
    }

    public boolean hasValues() {
        return ((this.values!= null)&&(this.values.size()> 0));
    }

    public DataField addValues(Value... values) {
        getValues().addAll(Arrays.asList(values));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasIntervals()) {
                status = PMMLObject.traverse(visitor, getIntervals());
            }
            if ((status == VisitorAction.CONTINUE)&&hasValues()) {
                status = PMMLObject.traverse(visitor, getValues());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Cyclic {

        @XmlEnumValue("0")
        ZERO("0"),
        @XmlEnumValue("1")
        ONE("1");
        private final String value;

        Cyclic(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static DataField.Cyclic fromValue(String v) {
            for (DataField.Cyclic c: DataField.Cyclic.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
