
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "rocGraph"
})
@XmlRootElement(name = "ROC", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_0))
public class ROC
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ROC>
{

    @XmlAttribute(name = "positiveTargetFieldValue", required = true)
    private String positiveTargetFieldValue;
    @XmlAttribute(name = "positiveTargetFieldDisplayValue")
    private String positiveTargetFieldDisplayValue;
    @XmlAttribute(name = "negativeTargetFieldValue")
    private String negativeTargetFieldValue;
    @XmlAttribute(name = "negativeTargetFieldDisplayValue")
    private String negativeTargetFieldDisplayValue;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "ROCGraph", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private ROCGraph rocGraph;
    private final static long serialVersionUID = 67305483L;

    public ROC() {
    }

    public ROC(
        @org.jpmml.model.annotations.Property("positiveTargetFieldValue")
        String positiveTargetFieldValue,
        @org.jpmml.model.annotations.Property("rocGraph")
        ROCGraph rocGraph) {
        this.positiveTargetFieldValue = positiveTargetFieldValue;
        this.rocGraph = rocGraph;
    }

    public String getPositiveTargetFieldValue() {
        return positiveTargetFieldValue;
    }

    public ROC setPositiveTargetFieldValue(
        @org.jpmml.model.annotations.Property("positiveTargetFieldValue")
        String positiveTargetFieldValue) {
        this.positiveTargetFieldValue = positiveTargetFieldValue;
        return this;
    }

    public String getPositiveTargetFieldDisplayValue() {
        return positiveTargetFieldDisplayValue;
    }

    public ROC setPositiveTargetFieldDisplayValue(
        @org.jpmml.model.annotations.Property("positiveTargetFieldDisplayValue")
        String positiveTargetFieldDisplayValue) {
        this.positiveTargetFieldDisplayValue = positiveTargetFieldDisplayValue;
        return this;
    }

    public String getNegativeTargetFieldValue() {
        return negativeTargetFieldValue;
    }

    public ROC setNegativeTargetFieldValue(
        @org.jpmml.model.annotations.Property("negativeTargetFieldValue")
        String negativeTargetFieldValue) {
        this.negativeTargetFieldValue = negativeTargetFieldValue;
        return this;
    }

    public String getNegativeTargetFieldDisplayValue() {
        return negativeTargetFieldDisplayValue;
    }

    public ROC setNegativeTargetFieldDisplayValue(
        @org.jpmml.model.annotations.Property("negativeTargetFieldDisplayValue")
        String negativeTargetFieldDisplayValue) {
        this.negativeTargetFieldDisplayValue = negativeTargetFieldDisplayValue;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public ROCGraph getROCGraph() {
        return rocGraph;
    }

    public ROC setROCGraph(
        @org.jpmml.model.annotations.Property("rocGraph")
        ROCGraph rocGraph) {
        this.rocGraph = rocGraph;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public ROC addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getROCGraph());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
