
package org.dmg.pmml.general_regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Optional;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "pCells"
})
@XmlRootElement(name = "ParamMatrix", namespace = "http://www.dmg.org/PMML-4_3")
public class ParamMatrix
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ParamMatrix>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "PCell", namespace = "http://www.dmg.org/PMML-4_3")
    @Optional((org.dmg.pmml.Version.PMML_4_0))
    private List<PCell> pCells;
    private final static long serialVersionUID = 67305483L;

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<PCell> getPCells() {
        if (pCells == null) {
            pCells = new ArrayList<PCell>();
        }
        return this.pCells;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public ParamMatrix addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasPCells() {
        return ((this.pCells!= null)&&(this.pCells.size()> 0));
    }

    public ParamMatrix addPCells(PCell... pCells) {
        getPCells().addAll(Arrays.asList(pCells));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasPCells()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getPCells());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
