
package org.dmg.pmml.support_vector_machine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "supportVectors",
    "coefficients"
})
@XmlRootElement(name = "SupportVectorMachine", namespace = "http://www.dmg.org/PMML-4_3")
public class SupportVectorMachine
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<SupportVectorMachine>
{

    @XmlAttribute(name = "targetCategory")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    private String targetCategory;
    @XmlAttribute(name = "alternateTargetCategory")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    private String alternateTargetCategory;
    @XmlAttribute(name = "threshold")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    private Double threshold;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "SupportVectors", namespace = "http://www.dmg.org/PMML-4_3")
    private SupportVectors supportVectors;
    @XmlElement(name = "Coefficients", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private Coefficients coefficients;
    private final static long serialVersionUID = 67305483L;

    public SupportVectorMachine() {
    }

    public SupportVectorMachine(
        @org.jpmml.model.annotations.Property("coefficients")
        Coefficients coefficients) {
        this.coefficients = coefficients;
    }

    public String getTargetCategory() {
        return targetCategory;
    }

    public SupportVectorMachine setTargetCategory(
        @org.jpmml.model.annotations.Property("targetCategory")
        String targetCategory) {
        this.targetCategory = targetCategory;
        return this;
    }

    public String getAlternateTargetCategory() {
        return alternateTargetCategory;
    }

    public SupportVectorMachine setAlternateTargetCategory(
        @org.jpmml.model.annotations.Property("alternateTargetCategory")
        String alternateTargetCategory) {
        this.alternateTargetCategory = alternateTargetCategory;
        return this;
    }

    public Double getThreshold() {
        return threshold;
    }

    public SupportVectorMachine setThreshold(
        @org.jpmml.model.annotations.Property("threshold")
        Double threshold) {
        this.threshold = threshold;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public SupportVectors getSupportVectors() {
        return supportVectors;
    }

    public SupportVectorMachine setSupportVectors(
        @org.jpmml.model.annotations.Property("supportVectors")
        SupportVectors supportVectors) {
        this.supportVectors = supportVectors;
        return this;
    }

    public Coefficients getCoefficients() {
        return coefficients;
    }

    public SupportVectorMachine setCoefficients(
        @org.jpmml.model.annotations.Property("coefficients")
        Coefficients coefficients) {
        this.coefficients = coefficients;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public SupportVectorMachine addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getSupportVectors(), getCoefficients());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
