
package org.dmg.pmml.support_vector_machine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Optional;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "vectorFields",
    "vectorInstances"
})
@XmlRootElement(name = "VectorDictionary", namespace = "http://www.dmg.org/PMML-4_3")
public class VectorDictionary
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<VectorDictionary>
{

    @XmlAttribute(name = "numberOfVectors")
    private Integer numberOfVectors;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "VectorFields", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @Added((org.dmg.pmml.Version.PMML_3_1))
    private VectorFields vectorFields;
    @XmlElement(name = "VectorInstance", namespace = "http://www.dmg.org/PMML-4_3")
    @Optional((org.dmg.pmml.Version.PMML_3_1))
    private List<VectorInstance> vectorInstances;
    private final static long serialVersionUID = 67305483L;

    public VectorDictionary() {
    }

    public VectorDictionary(
        @org.jpmml.model.annotations.Property("vectorFields")
        VectorFields vectorFields) {
        this.vectorFields = vectorFields;
    }

    public Integer getNumberOfVectors() {
        return numberOfVectors;
    }

    public VectorDictionary setNumberOfVectors(
        @org.jpmml.model.annotations.Property("numberOfVectors")
        Integer numberOfVectors) {
        this.numberOfVectors = numberOfVectors;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public VectorFields getVectorFields() {
        return vectorFields;
    }

    public VectorDictionary setVectorFields(
        @org.jpmml.model.annotations.Property("vectorFields")
        VectorFields vectorFields) {
        this.vectorFields = vectorFields;
        return this;
    }

    public List<VectorInstance> getVectorInstances() {
        if (vectorInstances == null) {
            vectorInstances = new ArrayList<VectorInstance>();
        }
        return this.vectorInstances;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public VectorDictionary addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasVectorInstances() {
        return ((this.vectorInstances!= null)&&(this.vectorInstances.size()> 0));
    }

    public VectorDictionary addVectorInstances(VectorInstance... vectorInstances) {
        getVectorInstances().addAll(Arrays.asList(vectorInstances));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getVectorFields());
            }
            if ((status == VisitorAction.CONTINUE)&&hasVectorInstances()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getVectorInstances());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
