
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "LinearNorm", namespace = "http://www.dmg.org/PMML-4_3")
public class LinearNorm
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<LinearNorm>
{

    @XmlAttribute(name = "orig", required = true)
    private double orig;
    @XmlAttribute(name = "norm", required = true)
    private double norm;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67305483L;

    public LinearNorm() {
    }

    public LinearNorm(
        @org.jpmml.model.annotations.Property("orig")
        double orig,
        @org.jpmml.model.annotations.Property("norm")
        double norm) {
        this.orig = orig;
        this.norm = norm;
    }

    public double getOrig() {
        return orig;
    }

    public LinearNorm setOrig(
        @org.jpmml.model.annotations.Property("orig")
        double orig) {
        this.orig = orig;
        return this;
    }

    public double getNorm() {
        return norm;
    }

    public LinearNorm setNorm(
        @org.jpmml.model.annotations.Property("norm")
        double norm) {
        this.norm = norm;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public LinearNorm addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
