
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "targets"
})
@XmlRootElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_3")
public class Targets
    extends org.dmg.pmml.PMMLObject
    implements Iterable<Target> , HasExtensions<Targets>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "Target", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<Target> targets;
    private final static long serialVersionUID = 67305483L;

    public Targets() {
    }

    public Targets(
        @Property("targets")
        List<Target> targets) {
        this.targets = targets;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<Target> getTargets() {
        if (targets == null) {
            targets = new ArrayList<Target>();
        }
        return this.targets;
    }

    public Iterator<Target> iterator() {
        return getTargets().iterator();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Targets addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasTargets() {
        return ((this.targets!= null)&&(this.targets.size()> 0));
    }

    public Targets addTargets(Target... targets) {
        getTargets().addAll(Arrays.asList(targets));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasTargets()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTargets());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
