
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "Value", namespace = "http://www.dmg.org/PMML-4_3")
public class Value
    extends org.dmg.pmml.PMMLObject
    implements HasDisplayValue<Value> , HasExtensions<Value> , Indexable<String>
{

    @XmlAttribute(name = "value", required = true)
    private String value;
    @XmlAttribute(name = "displayValue")
    private String displayValue;
    @XmlAttribute(name = "property")
    private Value.Property property;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67305483L;

    public Value() {
    }

    public Value(
        @org.jpmml.model.annotations.Property("value")
        String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public Value setValue(
        @org.jpmml.model.annotations.Property("value")
        String value) {
        this.value = value;
        return this;
    }

    public String getDisplayValue() {
        return displayValue;
    }

    public Value setDisplayValue(
        @org.jpmml.model.annotations.Property("displayValue")
        String displayValue) {
        this.displayValue = displayValue;
        return this;
    }

    public Value.Property getProperty() {
        if (property == null) {
            return Value.Property.VALID;
        } else {
            return property;
        }
    }

    public Value setProperty(
        @org.jpmml.model.annotations.Property("property")
        Value.Property property) {
        this.property = property;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public String getKey() {
        return getValue();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Value addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Property {

        @XmlEnumValue("valid")
        VALID("valid"),
        @XmlEnumValue("invalid")
        INVALID("invalid"),
        @XmlEnumValue("missing")
        MISSING("missing");
        private final String value;

        Property(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static Value.Property fromValue(String v) {
            for (Value.Property c: Value.Property.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
