
package org.dmg.pmml.baseline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.AnyDistribution;
import org.dmg.pmml.ContinuousDistribution;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.GaussianDistribution;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PoissonDistribution;
import org.dmg.pmml.UniformDistribution;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "continuousDistribution",
    "countTable",
    "normalizedCountTable",
    "fieldRefs"
})
@XmlRootElement(name = "Baseline", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_1))
public class Baseline
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Baseline>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "AnyDistribution", namespace = "http://www.dmg.org/PMML-4_3", type = AnyDistribution.class),
        @XmlElement(name = "GaussianDistribution", namespace = "http://www.dmg.org/PMML-4_3", type = GaussianDistribution.class),
        @XmlElement(name = "PoissonDistribution", namespace = "http://www.dmg.org/PMML-4_3", type = PoissonDistribution.class),
        @XmlElement(name = "UniformDistribution", namespace = "http://www.dmg.org/PMML-4_3", type = UniformDistribution.class)
    })
    private ContinuousDistribution continuousDistribution;
    @XmlElement(name = "CountTable", namespace = "http://www.dmg.org/PMML-4_3")
    private CountTable countTable;
    @XmlElement(name = "NormalizedCountTable", namespace = "http://www.dmg.org/PMML-4_3")
    private CountTable normalizedCountTable;
    @XmlElement(name = "FieldRef", namespace = "http://www.dmg.org/PMML-4_3")
    private List<FieldRef> fieldRefs;
    private final static long serialVersionUID = 67305483L;

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public ContinuousDistribution getContinuousDistribution() {
        return continuousDistribution;
    }

    public Baseline setContinuousDistribution(
        @Property("continuousDistribution")
        ContinuousDistribution continuousDistribution) {
        this.continuousDistribution = continuousDistribution;
        return this;
    }

    public CountTable getCountTable() {
        return countTable;
    }

    public Baseline setCountTable(
        @Property("countTable")
        CountTable countTable) {
        this.countTable = countTable;
        return this;
    }

    public CountTable getNormalizedCountTable() {
        return normalizedCountTable;
    }

    public Baseline setNormalizedCountTable(
        @Property("normalizedCountTable")
        CountTable normalizedCountTable) {
        this.normalizedCountTable = normalizedCountTable;
        return this;
    }

    public List<FieldRef> getFieldRefs() {
        if (fieldRefs == null) {
            fieldRefs = new ArrayList<FieldRef>();
        }
        return this.fieldRefs;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Baseline addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasFieldRefs() {
        return ((this.fieldRefs!= null)&&(this.fieldRefs.size()> 0));
    }

    public Baseline addFieldRefs(FieldRef... fieldRefs) {
        getFieldRefs().addAll(Arrays.asList(fieldRefs));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getContinuousDistribution(), getCountTable(), getNormalizedCountTable());
            }
            if ((status == VisitorAction.CONTINUE)&&hasFieldRefs()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getFieldRefs());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
