
package org.dmg.pmml.naive_bayes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "bayesInputs"
})
@XmlRootElement(name = "BayesInputs", namespace = "http://www.dmg.org/PMML-4_3")
public class BayesInputs
    extends org.dmg.pmml.PMMLObject
    implements Iterable<BayesInput> , HasExtensions<BayesInputs>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "BayesInput", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<BayesInput> bayesInputs;
    private final static long serialVersionUID = 67305483L;

    public BayesInputs() {
    }

    public BayesInputs(
        @Property("bayesInputs")
        List<BayesInput> bayesInputs) {
        this.bayesInputs = bayesInputs;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<BayesInput> getBayesInputs() {
        if (bayesInputs == null) {
            bayesInputs = new ArrayList<BayesInput>();
        }
        return this.bayesInputs;
    }

    public Iterator<BayesInput> iterator() {
        return getBayesInputs().iterator();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public BayesInputs addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasBayesInputs() {
        return ((this.bayesInputs!= null)&&(this.bayesInputs.size()> 0));
    }

    public BayesInputs addBayesInputs(BayesInput... bayesInputs) {
        getBayesInputs().addAll(Arrays.asList(bayesInputs));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasBayesInputs()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getBayesInputs());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
