
package org.dmg.pmml.naive_bayes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.AnyDistribution;
import org.dmg.pmml.ContinuousDistribution;
import org.dmg.pmml.Extension;
import org.dmg.pmml.GaussianDistribution;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PoissonDistribution;
import org.dmg.pmml.UniformDistribution;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "continuousDistribution"
})
@XmlRootElement(name = "TargetValueStat", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_2))
public class TargetValueStat
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<TargetValueStat>
{

    @XmlAttribute(name = "value", required = true)
    private String value;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "AnyDistribution", namespace = "http://www.dmg.org/PMML-4_3", type = AnyDistribution.class),
        @XmlElement(name = "GaussianDistribution", namespace = "http://www.dmg.org/PMML-4_3", type = GaussianDistribution.class),
        @XmlElement(name = "PoissonDistribution", namespace = "http://www.dmg.org/PMML-4_3", type = PoissonDistribution.class),
        @XmlElement(name = "UniformDistribution", namespace = "http://www.dmg.org/PMML-4_3", type = UniformDistribution.class)
    })
    private ContinuousDistribution continuousDistribution;
    private final static long serialVersionUID = 67305483L;

    public TargetValueStat() {
    }

    public TargetValueStat(
        @org.jpmml.model.annotations.Property("value")
        String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public TargetValueStat setValue(
        @org.jpmml.model.annotations.Property("value")
        String value) {
        this.value = value;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public ContinuousDistribution getContinuousDistribution() {
        return continuousDistribution;
    }

    public TargetValueStat setContinuousDistribution(
        @org.jpmml.model.annotations.Property("continuousDistribution")
        ContinuousDistribution continuousDistribution) {
        this.continuousDistribution = continuousDistribution;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public TargetValueStat addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getContinuousDistribution());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
