
package org.dmg.pmml.neural_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Entity;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "connections"
})
@XmlRootElement(name = "Neuron", namespace = "http://www.dmg.org/PMML-4_3")
public class Neuron
    extends Entity
    implements HasExtensions<Neuron>
{

    @XmlAttribute(name = "id", required = true)
    private String id;
    @XmlAttribute(name = "bias")
    private Double bias;
    @XmlAttribute(name = "width")
    private Double width;
    @XmlAttribute(name = "altitude")
    @Added((org.dmg.pmml.Version.PMML_3_2))
    private Double altitude;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "Con", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<Connection> connections;
    private final static long serialVersionUID = 67305483L;

    public Neuron() {
    }

    public Neuron(
        @org.jpmml.model.annotations.Property("id")
        String id,
        @org.jpmml.model.annotations.Property("connections")
        List<Connection> connections) {
        this.id = id;
        this.connections = connections;
    }

    public String getId() {
        return id;
    }

    public Neuron setId(
        @org.jpmml.model.annotations.Property("id")
        String id) {
        this.id = id;
        return this;
    }

    public Double getBias() {
        return bias;
    }

    public Neuron setBias(
        @org.jpmml.model.annotations.Property("bias")
        Double bias) {
        this.bias = bias;
        return this;
    }

    public Double getWidth() {
        return width;
    }

    public Neuron setWidth(
        @org.jpmml.model.annotations.Property("width")
        Double width) {
        this.width = width;
        return this;
    }

    public Double getAltitude() {
        return altitude;
    }

    public Neuron setAltitude(
        @org.jpmml.model.annotations.Property("altitude")
        Double altitude) {
        this.altitude = altitude;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<Connection> getConnections() {
        if (connections == null) {
            connections = new ArrayList<Connection>();
        }
        return this.connections;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Neuron addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasConnections() {
        return ((this.connections!= null)&&(this.connections.size()> 0));
    }

    public Neuron addConnections(Connection... connections) {
        getConnections().addAll(Arrays.asList(connections));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasConnections()) {
                status = PMMLObject.traverse(visitor, getConnections());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
