
package org.dmg.pmml.regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "numericPredictors",
    "categoricalPredictors",
    "predictorTerms"
})
@XmlRootElement(name = "RegressionTable", namespace = "http://www.dmg.org/PMML-4_3")
public class RegressionTable
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<RegressionTable>
{

    @XmlAttribute(name = "intercept", required = true)
    private double intercept;
    @XmlAttribute(name = "targetCategory")
    private String targetCategory;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "NumericPredictor", namespace = "http://www.dmg.org/PMML-4_3")
    private List<NumericPredictor> numericPredictors;
    @XmlElement(name = "CategoricalPredictor", namespace = "http://www.dmg.org/PMML-4_3")
    private List<CategoricalPredictor> categoricalPredictors;
    @XmlElement(name = "PredictorTerm", namespace = "http://www.dmg.org/PMML-4_3")
    private List<PredictorTerm> predictorTerms;
    private final static long serialVersionUID = 67305483L;

    public RegressionTable() {
    }

    public RegressionTable(
        @org.jpmml.model.annotations.Property("intercept")
        double intercept) {
        this.intercept = intercept;
    }

    public double getIntercept() {
        return intercept;
    }

    public RegressionTable setIntercept(
        @org.jpmml.model.annotations.Property("intercept")
        double intercept) {
        this.intercept = intercept;
        return this;
    }

    public String getTargetCategory() {
        return targetCategory;
    }

    public RegressionTable setTargetCategory(
        @org.jpmml.model.annotations.Property("targetCategory")
        String targetCategory) {
        this.targetCategory = targetCategory;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<NumericPredictor> getNumericPredictors() {
        if (numericPredictors == null) {
            numericPredictors = new ArrayList<NumericPredictor>();
        }
        return this.numericPredictors;
    }

    public List<CategoricalPredictor> getCategoricalPredictors() {
        if (categoricalPredictors == null) {
            categoricalPredictors = new ArrayList<CategoricalPredictor>();
        }
        return this.categoricalPredictors;
    }

    public List<PredictorTerm> getPredictorTerms() {
        if (predictorTerms == null) {
            predictorTerms = new ArrayList<PredictorTerm>();
        }
        return this.predictorTerms;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public RegressionTable addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasNumericPredictors() {
        return ((this.numericPredictors!= null)&&(this.numericPredictors.size()> 0));
    }

    public RegressionTable addNumericPredictors(NumericPredictor... numericPredictors) {
        getNumericPredictors().addAll(Arrays.asList(numericPredictors));
        return this;
    }

    public boolean hasCategoricalPredictors() {
        return ((this.categoricalPredictors!= null)&&(this.categoricalPredictors.size()> 0));
    }

    public RegressionTable addCategoricalPredictors(CategoricalPredictor... categoricalPredictors) {
        getCategoricalPredictors().addAll(Arrays.asList(categoricalPredictors));
        return this;
    }

    public boolean hasPredictorTerms() {
        return ((this.predictorTerms!= null)&&(this.predictorTerms.size()> 0));
    }

    public RegressionTable addPredictorTerms(PredictorTerm... predictorTerms) {
        getPredictorTerms().addAll(Arrays.asList(predictorTerms));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasNumericPredictors()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getNumericPredictors());
            }
            if ((status == VisitorAction.CONTINUE)&&hasCategoricalPredictors()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getCategoricalPredictors());
            }
            if ((status == VisitorAction.CONTINUE)&&hasPredictorTerms()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getPredictorTerms());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
